/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.IndirectStringReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class TypeId
extends IdItem
implements Comparable<TypeId> {
    private final IndirectStringReference nameReference = new IndirectStringReference(this, 0, StringId.USAGE_TYPE_NAME);

    public TypeId() {
        super(4);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public SectionType<TypeId> getSectionType() {
        return SectionType.TYPE_ID;
    }

    @Override
    public TypeKey getKey() {
        return this.checkKey(TypeKey.create(this.getName()));
    }

    @Override
    public void setKey(Key key) {
        TypeKey typeKey = (TypeKey)key;
        this.setKey(typeKey);
    }

    public void setKey(TypeKey key) {
        TypeKey old = this.getKey();
        if (Objects.equals(key, old)) {
            return;
        }
        this.nameReference.setString(key.getTypeName());
        this.keyChanged(old);
    }

    public String getName() {
        StringId stringId = this.getNameId();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public boolean isWide() {
        TypeKey key = this.getKey();
        if (key != null) {
            return key.isWide();
        }
        return false;
    }

    public StringId getNameId() {
        return (StringId)this.nameReference.getItem();
    }

    public IndirectStringReference getNameReference() {
        return this.nameReference;
    }

    @Override
    public void refresh() {
        this.nameReference.refresh();
    }

    @Override
    void cacheItems() {
        this.nameReference.pullItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getName());
    }

    @Override
    public int compareTo(TypeId typeId) {
        if (typeId == null) {
            return -1;
        }
        return this.nameReference.compareTo(typeId.nameReference);
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return this.getIndex() + ":string-index=" + this.nameReference.get();
    }

    public static boolean equals(TypeId typeId1, TypeId typeId2) {
        if (typeId1 == typeId2) {
            return true;
        }
        if (typeId1 == null) {
            return false;
        }
        return ObjectsUtil.equals(typeId1.getName(), typeId2.getName());
    }
}

