/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.reference.IdItemIndirectReference;
import com.reandroid.dex.reference.IdItemIndirectShortReference;
import com.reandroid.dex.reference.IndirectStringReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class MethodId
extends IdItem
implements Comparable<MethodId> {
    private final IdItemIndirectReference<TypeId> defining = new IdItemIndirectShortReference<TypeId>(SectionType.TYPE_ID, this, 0, USAGE_METHOD);
    private final IdItemIndirectReference<ProtoId> proto = new IdItemIndirectShortReference<ProtoId>(SectionType.PROTO_ID, this, 2, USAGE_METHOD);
    private final IndirectStringReference nameReference = new IndirectStringReference(this, 4, StringId.USAGE_METHOD_NAME);
    private static final int SIZE = 8;

    public MethodId() {
        super(8);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.singleThree(this, SingleIterator.of(this.defining.getItem()), SingleIterator.of(this.nameReference.getItem()), ((ProtoId)this.proto.getItem()).usedIds());
    }

    public String getName() {
        return this.nameReference.getString();
    }

    public void setName(String name) {
        this.setName(StringKey.create(name));
    }

    public StringKey getNameKey() {
        return this.nameReference.getKey();
    }

    public void setName(StringKey key) {
        MethodKey methodKey = this.getKey();
        if (methodKey == null) {
            this.nameReference.setKey(key);
        } else {
            this.setKey(methodKey.changeName(key));
        }
    }

    IndirectStringReference getNameReference() {
        return this.nameReference;
    }

    public TypeKey getDefining() {
        return (TypeKey)this.defining.getKey();
    }

    public TypeId getDefiningId() {
        return (TypeId)this.defining.getItem();
    }

    public int getParametersCount() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getParametersCount();
        }
        return 0;
    }

    public int getParameterRegistersCount() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getParameterRegistersCount();
        }
        return 0;
    }

    public TypeListKey getParameters() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getParameters();
        }
        return null;
    }

    public TypeList getParameterTypes() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getTypeList();
        }
        return null;
    }

    public ProtoId getProtoId() {
        return (ProtoId)this.proto.getItem();
    }

    public ProtoKey getProto() {
        return (ProtoKey)this.proto.getKey();
    }

    public TypeKey getReturnType() {
        ProtoId protoId = this.getProtoId();
        if (protoId != null) {
            return protoId.getReturnType();
        }
        return null;
    }

    public SectionType<MethodId> getSectionType() {
        return SectionType.METHOD_ID;
    }

    @Override
    public MethodKey getKey() {
        return this.checkKey(MethodKey.create(this.getDefining(), this.getNameKey(), this.getProto()));
    }

    @Override
    public void setKey(Key key) {
        this.setKey((MethodKey)key);
    }

    public void setKey(MethodKey key) {
        MethodKey old = this.getKey();
        if (key.equals(old)) {
            return;
        }
        this.defining.setKey(key.getDeclaring());
        this.nameReference.setKey(key.getNameKey());
        this.proto.setKey(key.getProto());
        this.keyChanged(old);
    }

    @Override
    public void refresh() {
        this.defining.refresh();
        this.proto.refresh();
        this.nameReference.refresh();
    }

    @Override
    void cacheItems() {
        this.defining.pullItem();
        this.proto.pullItem();
        this.nameReference.pullItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(writer, true);
    }

    public void append(SmaliWriter writer, boolean appendDefining) throws IOException {
        if (appendDefining) {
            this.getDefiningId().append(writer);
            writer.append("->");
        }
        writer.append(this.getName());
        writer.appendRequired(this.getProtoId());
    }

    @Override
    public int compareTo(MethodId methodId) {
        if (methodId == null) {
            return -1;
        }
        int i = this.defining.compareTo(methodId.defining);
        if (i != 0) {
            return i;
        }
        i = this.nameReference.compareTo(methodId.nameReference);
        if (i != 0) {
            return i;
        }
        return this.proto.compareTo(methodId.proto);
    }

    public String toString() {
        return this.getDefiningId() + "->" + this.getName() + this.getProtoId();
    }

    public static boolean equals(MethodId methodId, MethodId other) {
        return MethodId.equals(false, methodId, other);
    }

    public static boolean equals(boolean ignoreClass, MethodId methodId, MethodId other) {
        if (methodId == other) {
            return true;
        }
        if (methodId == null) {
            return false;
        }
        if (!IndirectStringReference.equals(methodId.getNameReference(), other.getNameReference())) {
            return false;
        }
        if (!ignoreClass && !TypeId.equals(methodId.getDefiningId(), other.getDefiningId())) {
            return false;
        }
        return ObjectsUtil.equals(methodId.getParameterTypes(), other.getParameterTypes());
    }
}

