/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;

public class UnknownHeaderBytes
extends ByteArray
implements DirectStreamReader,
BlockRefresh {
    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.updateSize();
        super.onReadBytes(reader);
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException {
        this.updateSize();
        return super.readBytes(inputStream);
    }

    @Override
    public void refresh() {
        this.updateSize();
    }

    private void updateSize() {
        this.setSize(this.computeUnknownSize());
    }

    private int computeUnknownSize() {
        DexHeader header = this.getParentInstance(DexHeader.class);
        if (header == null) {
            return 0;
        }
        int unknownSize = header.headerSize.get() - header.countBytes() - this.size();
        if (unknownSize < 0 || unknownSize > 255) {
            unknownSize = 0;
        }
        return unknownSize;
    }

    @Override
    public String toString() {
        int size = this.size();
        if (size > 0 && size <= 32) {
            return "size = " + size + " [" + HexUtil.toHexString(this.getBytesInternal()) + "]";
        }
        return super.toString();
    }
}

