/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.io.ByteReader;
import com.reandroid.dex.io.StreamUtil;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.OutputStream;

public class StringData
extends DataItem
implements SmaliFormat,
BlockRefresh,
OffsetSupplier,
OffsetReceiver,
Comparable<StringData> {
    private final StringDataContainer mDataContainer = new StringDataContainer(this);
    private StringKey mKey;

    public StringData() {
        super(1);
        this.addChildBlock(0, this.mDataContainer);
    }

    @Override
    public void removeSelf() {
        throw new DexException("Remove STRING_ID first before STRING_DATA");
    }

    public void removeSelf(StringId request) {
        if (request == this.getOffsetReference()) {
            super.removeSelf();
        } else if (!this.isRemoved()) {
            throw new DexException("Invalid remove request");
        }
    }

    @Override
    public StringKey getKey() {
        return this.mKey;
    }

    public StringKey updateString(StringKey stringKey) {
        if (stringKey == null) {
            stringKey = StringKey.EMPTY;
        }
        return this.writeKey(stringKey);
    }

    @Override
    public void setOffsetReference(IntegerReference reference) {
        StringId stringId = (StringId)reference;
        StringId current = this.getOffsetReference();
        if (stringId == current) {
            return;
        }
        if (stringId != null && current != null) {
            throw new IllegalArgumentException("String data already linked: " + this.getString());
        }
        super.setOffsetReference(reference);
    }

    @Override
    public StringId getOffsetReference() {
        return (StringId)super.getOffsetReference();
    }

    @Override
    public void setPosition(int position) {
        StringId stringId = this.getOffsetReference();
        if (stringId != null) {
            stringId.set(position);
        }
    }

    public SectionType<StringData> getSectionType() {
        return SectionType.STRING_DATA;
    }

    public String getString() {
        StringKey key = this.getKey();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    public void setString(String value) {
        this.updateString(StringKey.create(value));
    }

    private StringKey writeKey(StringKey stringKey) {
        StringKey oldKey = this.getKey();
        if (stringKey.equals(oldKey)) {
            return oldKey;
        }
        this.encodeString(stringKey.getString());
        this.mKey = stringKey;
        return stringKey;
    }

    void onStringBytesChanged() {
        this.mKey = StringKey.create(this.decodeString());
    }

    @Override
    public int countBytes() {
        return this.mDataContainer.countBytes();
    }

    @Override
    public byte[] getBytes() {
        return this.mDataContainer.getBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        counter.addCount(this.countBytes());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int start = reader.getPosition();
        int position = this.getOffset();
        reader.seek(position);
        String text = StringData.decodeString(StreamUtil.createByteReader(reader));
        int length = reader.getPosition() - position;
        reader.seek(position);
        StringDataContainer container = this.mDataContainer;
        container.setLength(length + 1);
        reader.readFully(container.getBytesInternal());
        reader.seek(start);
        this.mKey = StringKey.create(text);
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        return this.mDataContainer.onWriteBytes(stream);
    }

    @Override
    public void onRemovedInternal() {
        super.onRemovedInternal();
        this.setOffsetReference(null);
        this.mKey = null;
        this.mDataContainer.setLength(0);
    }

    @Override
    public int getUsageType() {
        StringId stringId = this.getOffsetReference();
        if (stringId != null) {
            return stringId.getUsageType();
        }
        return 0;
    }

    @Override
    public boolean isBlank() {
        return this.getOffsetReference() == null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.isRemoved()) {
            throw new IOException("REMOVED string data");
        }
        StringKey key = this.getKey();
        if (key == null) {
            throw new IOException("Null string key: " + this.toString());
        }
        key.append(writer, writer.isCommentUnicodeStrings());
    }

    @Override
    public int compareTo(StringData stringData) {
        if (stringData == null) {
            return -1;
        }
        if (stringData == this) {
            return 0;
        }
        return this.getString().compareTo(stringData.getString());
    }

    public String toString() {
        String text = this.getString();
        if (text != null) {
            return text;
        }
        return "NULL";
    }

    private String decodeString() {
        String text;
        try {
            text = StringData.decodeString(StreamUtil.createByteReader(this.mDataContainer.getBytesInternal()));
        }
        catch (IOException exception) {
            text = null;
        }
        return text;
    }

    private void encodeString(String text) {
        int length = text.length();
        this.mDataContainer.setLength(length * 3 + 4);
        byte[] buffer = this.mDataContainer.getBytesInternal();
        int position = DexBlockItem.writeUleb128(buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch != '\u0000' && ch < '\u0080') {
                buffer[position++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buffer[position++] = (byte)(ch >> 6 & 0x1F | 0xC0);
                buffer[position++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            buffer[position++] = (byte)(ch >> 12 & 0xF | 0xE0);
            buffer[position++] = (byte)(ch >> 6 & 0x3F | 0x80);
            buffer[position++] = (byte)(ch & 0x3F | 0x80);
        }
        buffer[position++] = 0;
        this.mDataContainer.setLength(position);
    }

    private static String decodeString(ByteReader reader) throws IOException {
        int utf16Length;
        char[] chars = new char[utf16Length];
        int outAt = 0;
        int at = 0;
        for (utf16Length = DexBlockItem.readUleb128(reader); utf16Length > 0; --utf16Length) {
            char out;
            int v0 = reader.read();
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (v0 == 0) {
                        return StringData.throwBadUtf8(v0, at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    int v1 = reader.read() & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    int v1 = reader.read();
                    if ((v1 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    int v2 = reader.read();
                    if ((v2 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v2, at + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return StringData.throwBadUtf8(v2, at + 2);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    return StringData.throwBadUtf8(v0, at);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) throws IOException {
        throw new IOException("bad utf-8 byte " + HexUtil.toHex2("", (byte)value) + " at offset " + offset);
    }

    static class StringDataContainer
    extends BlockItem {
        private final StringData stringData;

        StringDataContainer(StringData stringData) {
            super(0);
            this.stringData = stringData;
        }

        void setLength(int length) {
            this.setBytesLength(length, false);
        }

        @Override
        public byte[] getBytesInternal() {
            return super.getBytesInternal();
        }

        @Override
        protected void onBytesChanged() {
            this.stringData.onStringBytesChanged();
        }

        @Override
        public int onWriteBytes(OutputStream stream) throws IOException {
            return super.onWriteBytes(stream);
        }
    }
}

