/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.FieldDefArray;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Iterator;

public class StaticFieldDefArray
extends FieldDefArray {
    private Object mLockedBy;

    public StaticFieldDefArray(IntegerReference itemCount) {
        super(itemCount);
    }

    @Override
    public FieldDef createNext() {
        FieldDef fieldDef = (FieldDef)super.createNext();
        fieldDef.addAccessFlag(AccessFlag.STATIC);
        return fieldDef;
    }

    boolean isInitializedInStaticConstructor(FieldDef fieldDef) {
        FieldKey fieldKey = fieldDef.getKey();
        if (fieldKey == null) {
            return false;
        }
        ClassId classId = this.getClassId();
        if (classId == null) {
            return false;
        }
        MethodKey methodKey = MethodKey.STATIC_CONSTRUCTOR.changeDeclaring(fieldKey.getDeclaring());
        MethodDef methodDef = (MethodDef)classId.getDef(methodKey);
        if (methodDef == null) {
            return false;
        }
        InstructionList instructionList = methodDef.getInstructionList();
        if (instructionList == null) {
            return false;
        }
        for (Ins ins : instructionList) {
            SizeXIns sizeXIns;
            if (!(ins instanceof SizeXIns) || !(sizeXIns = (SizeXIns)ins).getOpcode().isFieldPut() || !fieldKey.equals(sizeXIns.getKey())) continue;
            return true;
        }
        return false;
    }

    Key getStaticValue(FieldDef def) {
        if (this.mLockedBy != null) {
            return def.cachedStaticValue();
        }
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null) {
            return encodedArray.getValueKey(def.getIndex());
        }
        return null;
    }

    void setStaticValue(FieldDef def, Key key) {
        if (this.mLockedBy != null) {
            def.cachedStaticValue(key);
            return;
        }
        Object lock = this.cacheStaticValues();
        def.cachedStaticValue(key);
        this.releaseStaticValues(lock);
    }

    private Object cacheStaticValues() {
        Object lock;
        if (this.mLockedBy != null) {
            return null;
        }
        this.mLockedBy = lock = new Object();
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ((FieldDef)this.get(i)).cachedStaticValue(encodedArray.getValueKey(i));
            }
        }
        return lock;
    }

    private void releaseStaticValues(Object lock) {
        ArrayValueKey encoded;
        if (this.mLockedBy == null || this.mLockedBy != lock) {
            return;
        }
        ClassId classId = this.getClassId();
        if (classId == null) {
            return;
        }
        ArrayValueKey cached = this.buildCachedKey();
        if (!ObjectsUtil.equals(cached, encoded = classId.getStaticValues())) {
            classId.setStaticValues(cached);
        }
        this.mLockedBy = null;
    }

    private ArrayValueKey buildCachedKey() {
        int lastIndex = this.lastCachedKeyIndex();
        if (lastIndex < 0) {
            return null;
        }
        int length = lastIndex + 1;
        Key[] elements = new Key[length];
        for (int i = 0; i < length; ++i) {
            FieldDef fieldDef = (FieldDef)this.get(i);
            Key key = fieldDef.cachedStaticValue();
            if (key == null) {
                key = DexValueType.createDefaultValue(fieldDef.getKey().getType());
            }
            elements[i] = key;
            fieldDef.cachedStaticValue(null);
        }
        return ArrayValueKey.of(elements);
    }

    private int lastCachedKeyIndex() {
        int result = -1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Key key = ((FieldDef)this.get(i)).cachedStaticValue();
            if (key == null) continue;
            result = i;
        }
        return result;
    }

    private EncodedArray getEncodedArray() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getStaticValuesEncodedArray();
        }
        return null;
    }

    @Override
    protected Object onRemoveRequestStarted() {
        return this.cacheStaticValues();
    }

    @Override
    protected void onRemoveRequestCompleted(Object lock) {
        this.releaseStaticValues(lock);
        super.onRemoveRequestCompleted(lock);
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        Object forceRelease = this.mLockedBy;
        this.releaseStaticValues(forceRelease);
    }

    @Override
    Object onPreSort() {
        super.onPreSort();
        return this.cacheStaticValues();
    }

    @Override
    void onPostSort(Object lock) {
        super.onPostSort(lock);
        this.releaseStaticValues(lock);
    }

    @Override
    public void merge(DefArray<FieldDef> defArray) {
        Object lock = this.cacheStaticValues();
        super.merge(defArray);
        this.releaseStaticValues(lock);
    }

    @Override
    void onMerged(FieldDef def, FieldDef source) {
        Key value = source.getStaticValue();
        if (value != null) {
            this.setStaticValue(def, value);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.setStateWritingFields(true);
        super.append(writer);
        writer.setStateWritingFields(false);
    }

    @Override
    public void fromSmali(Iterator<? extends Smali> iterator) {
        Object lock = this.cacheStaticValues();
        super.fromSmali(iterator);
        this.releaseStaticValues(lock);
    }
}

