/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.data.HiddenApiData;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiIndex;
import com.reandroid.dex.data.HiddenApiRestrictions;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

class HiddenApiIndexList
extends BlockList<HiddenApiIndex>
implements Iterable<HiddenApiIndex> {
    public HiddenApiIndexList() {
        this.setCreator(new HiddenApiIndexCreator(this));
    }

    public HiddenApiFlagValue getFlagValue(Key key) {
        HiddenApiIndex apiIndex = this.get(key.getDeclaring());
        if (apiIndex != null) {
            return apiIndex.get(key);
        }
        return null;
    }

    public HiddenApiIndex get(TypeKey typeKey) {
        return this.get(this.getClassId(typeKey));
    }

    public HiddenApiIndex get(ClassId classId) {
        if (classId == null || classId.isRemoved()) {
            return null;
        }
        HiddenApiIndex apiIndex = (HiddenApiIndex)this.get(classId.getIndex());
        if (apiIndex != null && apiIndex.getClassId() == classId) {
            return apiIndex;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            apiIndex = (HiddenApiIndex)this.get(i);
            if (apiIndex.getClassId() != classId) continue;
            return apiIndex;
        }
        HiddenApiRestrictions parent = this.getParentInstance(HiddenApiRestrictions.class);
        apiIndex = parent.createNew(classId);
        return apiIndex;
    }

    HiddenApiIndex createNext(ClassId classId, HiddenApiData apiData) {
        HiddenApiIndex apiIndex = new HiddenApiIndex(classId);
        this.add(apiIndex);
        apiIndex.linkData(apiData);
        return apiIndex;
    }

    boolean isAllNoRestrictions() {
        for (HiddenApiIndex apiIndex : this) {
            if (apiIndex.isAllNoRestrictions()) continue;
            return false;
        }
        return true;
    }

    public Iterator<HiddenApiIndex> getHiddenApis() {
        return FilterIterator.of(this.iterator(), HiddenApiIndex::hasValidDataOffset);
    }

    @Override
    public int countBytes() {
        return this.size() * 4;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.ensureClassesLinked();
    }

    private void ensureClassesLinked() {
        this.removeIf(HiddenApiIndex::isNull);
        Section<ClassId> section = this.getClassIdSection();
        if (section == null) {
            return;
        }
        boolean needsSort = false;
        int size = section.getCount();
        for (int i = 0; i < size; ++i) {
            ClassId classId = (ClassId)section.get(i);
            HiddenApiIndex apiIndex = this.get(classId);
            if (needsSort) continue;
            needsSort = classId.getIndex() != apiIndex.getIndex();
        }
        if (needsSort) {
            this.sort(CompareUtil.getComparableComparator());
        }
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        this.setSize(this.getClassIdSectionCount());
        super.readChildes(reader);
    }

    private int getClassIdSectionCount() {
        Section<ClassId> section = this.getClassIdSection();
        if (section != null) {
            return section.getCount();
        }
        return 0;
    }

    private ClassId getClassId(TypeKey typeKey) {
        Section<ClassId> section = this.getClassIdSection();
        if (section != null) {
            return section.get(typeKey);
        }
        return null;
    }

    Section<ClassId> getClassIdSection() {
        SectionList sectionList = this.getParentSectionList();
        if (sectionList != null) {
            return sectionList.getSection(SectionType.CLASS_ID);
        }
        return (Section)ObjectsUtil.getNull();
    }

    private SectionList getParentSectionList() {
        return this.getParentInstance(SectionList.class);
    }

    static class HiddenApiIndexCreator
    implements Creator<HiddenApiIndex> {
        private final HiddenApiIndexList hiddenApiIndexList;

        HiddenApiIndexCreator(HiddenApiIndexList hiddenApiIndexList) {
            this.hiddenApiIndexList = hiddenApiIndexList;
        }

        @Override
        public HiddenApiIndex newInstance() {
            throw new RuntimeException("Must call newInstanceAt(index)");
        }

        @Override
        public HiddenApiIndex newInstanceAt(int index) {
            return new HiddenApiIndex((ClassId)this.hiddenApiIndexList.getClassIdSection().get(index));
        }
    }
}

