/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.HiddenApiData;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiIndexList;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;

class HiddenApiIndex
extends BlockItem
implements Comparable<HiddenApiIndex>,
BlockRefresh {
    private final IntegerReference dataOffset = new IndirectInteger(this, 0);
    private final ClassId classId;
    private HiddenApiData hiddenApiData;

    public HiddenApiIndex(ClassId classId) {
        super(4);
        this.classId = classId;
    }

    public HiddenApiFlagValue get(Key key) {
        HiddenApiData hiddenApiData = this.getHiddenApiData();
        if (hiddenApiData != null) {
            return hiddenApiData.get(this.getClassId().getDef(key));
        }
        return null;
    }

    public IntegerReference getDataOffset() {
        return this.dataOffset;
    }

    public boolean hasValidDataOffset() {
        return this.dataOffset.get() != 0;
    }

    public HiddenApiData getHiddenApiData() {
        return this.hiddenApiData;
    }

    void linkData(HiddenApiData hiddenApiData) {
        this.hiddenApiData = hiddenApiData;
        hiddenApiData.setOffsetReference(this.getDataOffset());
        hiddenApiData.setClassId(this.getClassId());
    }

    boolean isAllNoRestrictions() {
        HiddenApiData apiData = this.getHiddenApiData();
        return apiData == null || apiData.isAllNoRestrictions();
    }

    public TypeKey getClassType() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getKey();
        }
        return null;
    }

    public ClassId getClassId() {
        return this.classId;
    }

    public void removeSelf() {
        HiddenApiIndexList parent = this.getParentInstance(HiddenApiIndexList.class);
        if (parent != null) {
            parent.remove(this);
        }
    }

    @Override
    public boolean isNull() {
        ClassId classId = this.getClassId();
        return classId == null || classId.isRemoved();
    }

    @Override
    public void refresh() {
        ClassId classId = this.getClassId();
        if (classId.isRemoved()) {
            this.removeSelf();
            return;
        }
        HiddenApiData apiData = this.getHiddenApiData();
        int offset = apiData == null ? 0 : apiData.getOffset();
        this.dataOffset.set(offset);
    }

    @Override
    public int compareTo(HiddenApiIndex hiddenApiIndex) {
        if (hiddenApiIndex == null) {
            return -1;
        }
        return SectionTool.compareIdx(this.getClassId(), hiddenApiIndex.getClassId());
    }

    public String toString() {
        return this.getClassType() + " {" + this.getDataOffset() + "}";
    }
}

