/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.EditableItem;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public abstract class DefArray<T extends Def<?>>
extends CountedBlockList<T>
implements Iterable<T>,
EditableItem,
SmaliFormat,
IdUsageIterator {
    private ClassId mClassId;

    public DefArray(IntegerReference countReference, Creator<T> creator) {
        super(creator, countReference);
    }

    @Override
    public void onPreRemove(T item) {
        AnnotationsDirectory directory = this.getUniqueAnnotationsDirectory();
        if (directory != null) {
            directory.remove((Def<?>)item);
        }
        this.resetIndex();
        super.onPreRemove(item);
        ((Def)item).onRemove();
    }

    public boolean sort() {
        return this.sort(CompareUtil.getComparableComparator());
    }

    @Override
    public final boolean sort(Comparator<? super T> comparator) {
        if (!this.needsSort(comparator)) {
            this.sortAnnotations();
            return false;
        }
        Object lock = this.onPreSort();
        boolean changed = super.sort(comparator);
        this.onPostSort(lock);
        return changed;
    }

    Object onPreSort() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            classId.getUniqueAnnotationsDirectory();
        }
        this.linkAnnotation();
        return null;
    }

    void onPostSort(Object lock) {
        this.resetIndex();
        this.sortAnnotations();
    }

    void sortAnnotations() {
    }

    @Override
    protected void onRemoveRequestCompleted(Object lock) {
        super.onRemoveRequestCompleted(lock);
        this.updateCountReference();
    }

    public T getOrCreate(Key key) {
        Object item = this.get(key);
        if (item != null) {
            return item;
        }
        item = this.createNext();
        ((Def)item).setKey(key);
        return item;
    }

    public T get(Key key) {
        for (Def def : this) {
            if (!key.equals(def.getKey())) continue;
            return (T)def;
        }
        return null;
    }

    @Override
    public T createNext() {
        Def item = (Def)super.createNext();
        this.updateCountReference();
        return (T)item;
    }

    public void clear() {
        this.clearChildes();
    }

    private ClassId searchClassId() {
        ClassId classId = this.mClassId;
        if (classId != null) {
            return classId;
        }
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            classId = ((Def)iterator.next()).getClassId();
        }
        return classId;
    }

    public ClassId getClassId() {
        return this.mClassId;
    }

    public void setClassId(ClassId classId) {
        if (this.mClassId == classId) {
            return;
        }
        this.mClassId = classId;
        if (classId != null) {
            this.linkAnnotation();
        }
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.linkAnnotation();
        if (this.sort()) {
            this.resetIndex();
        }
    }

    public ClassData getClassData() {
        return this.getParentInstance(ClassData.class);
    }

    private void linkAnnotation() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            directory.link((Def)this.get(i));
        }
    }

    AnnotationsDirectory getAnnotationsDirectory() {
        ClassId classId = this.searchClassId();
        if (classId == null) {
            return null;
        }
        return classId.getAnnotationsDirectory();
    }

    AnnotationsDirectory getUniqueAnnotationsDirectory() {
        ClassId classId = this.searchClassId();
        if (classId == null) {
            return null;
        }
        return classId.getUniqueAnnotationsDirectory();
    }

    private void resetIndex() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Def)this.get(i)).resetIndex();
        }
    }

    public void replaceKeys(Key search, Key replace) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Def)this.get(i)).replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Def)this.get(i)).editInternal(user);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<Def<?>, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(Def<?> element) {
                return element.usedIds();
            }
        };
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
    }

    public void merge(DefArray<T> defArray) {
        int size = defArray.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            Def def = (Def)this.get(i);
            Def source = (Def)defArray.get(i);
            def.merge(source);
            this.onMerged(def, source);
        }
        this.updateCountReference();
        this.linkAnnotation();
    }

    void onMerged(T def, T source) {
    }

    public void fromSmali(Iterator<? extends Smali> iterator) {
        while (iterator.hasNext()) {
            this.fromSmali(iterator.next());
        }
    }

    public T fromSmali(Smali smali) {
        Block item = this.createNext();
        ((Def)item).fromSmali(smali);
        return (T)item;
    }

    public Iterator<SmaliDef> toSmali() {
        return ComputeIterator.of(this.iterator(), Def::toSmali);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Def)this.get(i)).append(writer);
            writer.newLine();
        }
    }
}

