/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.IndirectShort;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class CodeItem
extends DataItem
implements RegistersTable,
PositionAlignedItem,
KeyReference {
    private final Header header = new Header(this);
    private final InstructionList instructionList = new InstructionList(this);
    private TryBlock tryBlock = null;
    private final DataKey<CodeItem> codeItemKey = new DataKey<CodeItem>(this);
    private MethodDef methodDef;

    public CodeItem() {
        super(3);
        this.addChildBlock(0, this.header);
        this.addChildBlock(1, this.instructionList);
    }

    @Override
    public DataKey<CodeItem> getKey() {
        return this.codeItemKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey codeItemKey = (DataKey)key;
        this.merge((CodeItem)codeItemKey.getItem());
    }

    public SectionType<CodeItem> getSectionType() {
        return SectionType.CODE;
    }

    @Override
    public int getRegistersCount() {
        return this.header.registersCount.get();
    }

    @Override
    public void setRegistersCount(int count) {
        this.header.registersCount.set(count);
    }

    @Override
    public int getParameterRegistersCount() {
        return this.header.parameterRegisters.get();
    }

    @Override
    public void setParameterRegistersCount(int count) {
        this.header.parameterRegisters.set(count);
    }

    @Override
    public boolean ensureLocalRegistersCount(int locals) {
        if (locals == 0) {
            return true;
        }
        if (locals <= this.getLocalRegistersCount()) {
            return true;
        }
        int params = this.getParameterRegistersCount();
        int current = this.getLocalRegistersCount();
        int diff = locals - current;
        InstructionList instructionList = this.getInstructionList();
        if (!instructionList.canAddLocalRegisters(diff)) {
            return false;
        }
        if (diff > 0) {
            instructionList.addLocalRegisters(diff);
        }
        this.setRegistersCount(locals + params);
        return true;
    }

    public Iterator<DebugElement> getDebugLabels() {
        DebugInfo debugInfo = this.getDebugInfo();
        if (debugInfo != null) {
            return debugInfo.getExtraLines();
        }
        return EmptyIterator.of();
    }

    public DebugInfo getDebugInfo() {
        return (DebugInfo)this.header.debugInfoOffset.getItem();
    }

    public DebugInfo getOrCreateDebugInfo() {
        return this.header.debugInfoOffset.getOrCreateUniqueItem(this);
    }

    public void removeDebugInfo() {
        if (this.getDebugInfo() == null) {
            return;
        }
        this.setDebugInfo(null);
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        this.header.debugInfoOffset.setItem(debugInfo);
    }

    public InstructionList getInstructionList() {
        return this.instructionList;
    }

    public IntegerReference getTryCountReference() {
        return this.header.tryBlockCount;
    }

    public Iterable<ExtraLine> getExtraLines() {
        return () -> CombiningIterator.two(this.getTryBlockLabels(), this.getDebugLabels());
    }

    public Iterator<Label> getTryBlockLabels() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock == null || tryBlock.isNull()) {
            return EmptyIterator.of();
        }
        return tryBlock.getLabels();
    }

    public TryBlock getTryBlock() {
        return this.tryBlock;
    }

    public TryBlock getOrCreateTryBlock() {
        this.initTryBlock();
        return this.tryBlock;
    }

    public void removeTryBlock() {
        TryBlock tryBlock = this.tryBlock;
        if (tryBlock == null) {
            return;
        }
        this.tryBlock = null;
        this.header.tryBlockCount.set(0);
        tryBlock.setParent(null);
    }

    public boolean compactSimilarCatches() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            return tryBlock.compactSimilarCatches();
        }
        return false;
    }

    public boolean flattenTryItems() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            return tryBlock.flattenCompactCatches();
        }
        return false;
    }

    public boolean splitTryHandlers() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            return tryBlock.splitTryHandlers();
        }
        return false;
    }

    public boolean combineTries() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            return tryBlock.combineTries();
        }
        return false;
    }

    public MethodDef getMethodDef() {
        return this.methodDef;
    }

    public void setMethodDef(MethodDef methodDef) {
        this.methodDef = methodDef;
    }

    IntegerReference getInstructionCodeUnitsReference() {
        return this.header.instructionCodeUnits;
    }

    IntegerReference getInstructionOutsReference() {
        return this.header.outs;
    }

    void initTryBlock() {
        if (this.tryBlock == null) {
            this.tryBlock = new TryBlock(this);
            this.addChildBlock(2, this.tryBlock);
        }
    }

    @Override
    public DexPositionAlign getPositionAlign() {
        if (this.tryBlock != null) {
            return this.tryBlock.getPositionAlign();
        }
        if (this.instructionList != null) {
            return this.instructionList.getBlockAlign();
        }
        return new DexPositionAlign();
    }

    @Override
    public void removeLastAlign() {
        if (this.tryBlock != null) {
            this.tryBlock.getPositionAlign().setSize(0);
        } else if (this.instructionList != null) {
            this.instructionList.getBlockAlign().setSize(0);
        }
    }

    public void replaceKeys(Key search, Key replace) {
        this.getInstructionList().replaceKeys(search, replace);
    }

    @Override
    public void edit() {
        this.editInternal(this);
    }

    @Override
    public void editInternal(Block user) {
        this.header.editInternal(user);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null && tryBlock.isEmpty()) {
            this.removeTryBlock();
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        DebugInfo debugInfo = this.getDebugInfo();
        Iterator<Object> iterator1 = debugInfo == null ? EmptyIterator.of() : debugInfo.usedIds();
        TryBlock tryBlock = this.getTryBlock();
        Iterator<Object> iterator2 = tryBlock == null ? EmptyIterator.of() : tryBlock.usedIds();
        return CombiningIterator.three(this.getInstructionList().usedIds(), iterator1, iterator2);
    }

    public void merge(CodeItem codeItem) {
        if (codeItem == this) {
            return;
        }
        this.header.merge(codeItem.header);
        this.getInstructionList().merge(codeItem.getInstructionList());
        TryBlock comingTry = codeItem.getTryBlock();
        if (comingTry != null) {
            TryBlock tryBlock = this.getOrCreateTryBlock();
            tryBlock.merge(comingTry);
        }
    }

    public void fromSmali(SmaliMethod smaliMethod) {
        this.setRegistersCount(smaliMethod.getRegistersCount());
        this.setParameterRegistersCount(smaliMethod.getParameterRegistersCount());
        this.getInstructionList().fromSmali(smaliMethod.getCodeSet());
        Iterator<SmaliCodeTryItem> iterator = smaliMethod.getTryItems();
        TryBlock tryBlock = null;
        if (iterator.hasNext()) {
            tryBlock = this.getOrCreateTryBlock();
        }
        while (iterator.hasNext()) {
            tryBlock.fromSmali(iterator.next());
        }
        if (smaliMethod.hasDebugElements()) {
            DebugInfo debugInfo = this.getOrCreateDebugInfo();
            debugInfo.getDebugSequence().fromSmali(smaliMethod.getCodeSet());
        }
        if (tryBlock != null) {
            tryBlock.combineTries();
            tryBlock.compactSimilarCatches();
            tryBlock.refresh();
        }
    }

    public void toSmali(SmaliMethod smaliMethod) {
        SmaliMethod.SmaliRegistersCount registersCount = smaliMethod.getSmaliRegistersCount();
        registersCount.setLocalsMode(true);
        registersCount.setValue(this.getLocalRegistersCount());
        this.getInstructionList().toSmali(smaliMethod);
    }

    public void appendRegistersCount(SmaliWriter writer) throws IOException {
        writer.setCurrentRegistersTable(this);
        writer.newLine();
        if (writer.isLocalRegistersCount()) {
            SmaliDirective.LOCALS.append(writer);
            writer.appendInteger(this.getLocalRegistersCount());
        } else {
            SmaliDirective.REGISTERS.append(writer);
            writer.appendInteger(this.getRegistersCount());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CodeItem codeItem = (CodeItem)obj;
        return this.header.equals(codeItem.header) && this.instructionList.equals(codeItem.instructionList) && ObjectsUtil.equals(this.tryBlock, codeItem.tryBlock);
    }

    public int hashCode() {
        int hash = this.header.hashCode();
        hash = hash * 31 + this.instructionList.hashCode();
        hash *= 31;
        TryBlock tryBlock = this.tryBlock;
        if (tryBlock != null) {
            hash += tryBlock.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.header.toString() + "\n instructionList=" + this.instructionList + "\n tryBlock=" + this.tryBlock + "\n debug=" + this.getDebugInfo();
    }

    static class Header
    extends SectionItem
    implements BlockRefresh {
        private final CodeItem codeItem;
        final IntegerReference registersCount;
        final IntegerReference parameterRegisters;
        final IntegerReference outs;
        final IntegerReference tryBlockCount;
        final DataItemIndirectReference<DebugInfo> debugInfoOffset;
        final IntegerReference instructionCodeUnits;

        public Header(CodeItem codeItem) {
            super(16);
            this.codeItem = codeItem;
            int offset = -2;
            this.registersCount = new IndirectShort(this, offset += 2);
            this.parameterRegisters = new IndirectShort(this, offset += 2);
            this.outs = new IndirectShort(this, offset += 2);
            this.tryBlockCount = new IndirectShort(this, offset += 2);
            this.debugInfoOffset = new DataItemIndirectReference<DebugInfo>(SectionType.DEBUG_INFO, this, offset += 2, UsageMarker.USAGE_DEBUG);
            this.instructionCodeUnits = new IndirectInteger(this, offset + 4);
        }

        @Override
        public void refresh() {
            this.debugInfoOffset.addUniqueUser(this.codeItem);
            this.debugInfoOffset.refresh();
            if (this.codeItem.getTryBlock() == null) {
                this.tryBlockCount.set(0);
            }
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
            super.onReadBytes(reader);
            this.debugInfoOffset.pullItem();
            this.debugInfoOffset.addUniqueUser(this.codeItem);
            if (this.tryBlockCount.get() != 0) {
                this.codeItem.initTryBlock();
            }
        }

        public void onRemove() {
            this.debugInfoOffset.setItem(null);
        }

        @Override
        public void editInternal(Block user) {
            this.debugInfoOffset.editInternal(user);
        }

        public void merge(Header header) {
            this.registersCount.set(header.registersCount.get());
            this.parameterRegisters.set(header.parameterRegisters.get());
            this.outs.set(header.outs.get());
            this.tryBlockCount.set(header.tryBlockCount.get());
            DebugInfo comingDebug = (DebugInfo)header.debugInfoOffset.getItem();
            if (comingDebug != null) {
                this.debugInfoOffset.setKey(comingDebug.getKey());
                this.debugInfoOffset.addUniqueUser(this.codeItem);
            }
            this.instructionCodeUnits.set(header.instructionCodeUnits.get());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Header header = (Header)obj;
            return this.registersCount.get() == header.registersCount.get() && this.parameterRegisters.get() == header.parameterRegisters.get() && this.outs.get() == header.outs.get() && this.tryBlockCount.get() == header.tryBlockCount.get() && this.instructionCodeUnits.get() == header.instructionCodeUnits.get() && ObjectsUtil.equals(this.debugInfoOffset.getItem(), header.debugInfoOffset.getItem());
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.registersCount.get();
            hash = hash * 31 + this.parameterRegisters.get();
            hash = hash * 31 + this.outs.get();
            hash = hash * 31 + this.tryBlockCount.get();
            hash = hash * 31 + this.instructionCodeUnits.get();
            hash *= 31;
            DebugInfo info = (DebugInfo)this.debugInfoOffset.getItem();
            if (info != null) {
                hash += info.hashCode();
            }
            return hash;
        }

        public String toString() {
            return "registers=" + this.registersCount + ", parameters=" + this.parameterRegisters + ", outs=" + this.outs + ", tries=" + this.tryBlockCount + ", debugInfo=" + this.debugInfoOffset + ", codeUnits=" + this.instructionCodeUnits;
        }
    }
}

