/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.dalvik.DalvikAnnotation;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.DalvikSignatureKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.utils.StringsUtil;
import java.util.Iterator;

public class DalvikSignature
extends DalvikAnnotation {
    private DalvikSignature(AnnotatedProgram annotatedProgram) {
        super(annotatedProgram, TypeKey.DALVIK_Signature);
    }

    public Iterator<String> values() {
        return this.getArrayKey().stringValuesIterator();
    }

    public ArrayValueKey getArrayKey() {
        ArrayValueKey key = (ArrayValueKey)this.getKey().getValue(Key.DALVIK_value);
        if (key == null) {
            key = ArrayValueKey.empty();
        }
        return key;
    }

    public void setArrayKey(ArrayValueKey arrayKey) {
        this.setKey(this.getKey().add(Key.DALVIK_value, arrayKey));
    }

    public String getString() {
        return StringsUtil.join(this.values(), (Object)"");
    }

    public DalvikSignatureKey getSignature() {
        return DalvikSignatureKey.parse(this.getString());
    }

    public void setSignature(DalvikSignatureKey key) {
        if (key != null) {
            this.setArrayKey(key.toStringValues());
        }
    }

    public void replace(TypeKey search, TypeKey replace) {
        DalvikSignatureKey signatureKey = this.getSignature();
        if (signatureKey != null) {
            this.setSignature(signatureKey.replaceKey(search, replace));
        }
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public static DalvikSignature of(AnnotatedProgram annotatedProgram) {
        if (annotatedProgram.hasAnnotation(TypeKey.DALVIK_Signature)) {
            return new DalvikSignature(annotatedProgram);
        }
        return null;
    }

    public static DalvikSignature getOrCreate(AnnotatedProgram annotatedProgram) {
        if (!annotatedProgram.hasAnnotation(TypeKey.DALVIK_Signature)) {
            annotatedProgram.addAnnotation(AnnotationItemKey.create(AnnotationVisibility.SYSTEM, TypeKey.DALVIK_Signature, AnnotationElementKey.create(Key.DALVIK_value, ArrayValueKey.empty())));
        }
        return DalvikSignature.of(annotatedProgram);
    }
}

