/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.dalvik.DalvikAnnotation;
import com.reandroid.dex.dalvik.DalvikEnclosingClass;
import com.reandroid.dex.dalvik.DalvikEnclosingMethod;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.NullValueKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.utils.ObjectsUtil;

public abstract class DalvikEnclosing<T extends Key>
extends DalvikAnnotation {
    public DalvikEnclosing(AnnotatedProgram annotatedProgram, TypeKey annotationType) {
        super(annotatedProgram, annotationType);
    }

    public T getEnclosing() {
        Key value = this.readValue(Key.DALVIK_value);
        if (value == null || value instanceof NullValueKey) {
            return null;
        }
        return (T)((Key)ObjectsUtil.cast(value));
    }

    public void setEnclosing(T enclosing) {
        NullValueKey value = enclosing == null ? NullValueKey.INSTANCE : enclosing;
        this.writeValue(Key.DALVIK_value, value);
    }

    public TypeKey getEnclosingClass() {
        T key = this.getEnclosing();
        if (key != null) {
            return key.getDeclaring();
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getEnclosing());
    }

    public static DalvikEnclosing<?> of(AnnotatedProgram annotatedProgram) {
        DalvikEnclosing enclosing = DalvikEnclosingClass.of(annotatedProgram);
        if (enclosing == null) {
            enclosing = DalvikEnclosingMethod.of(annotatedProgram);
        }
        return enclosing;
    }
}

