/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;

public class Register
implements SmaliFormat,
Comparable<Register> {
    private final int number;
    private final boolean parameter;
    private final RegistersTable registersTable;

    public Register(int number, boolean parameter, RegistersTable registersTable) {
        this.number = number;
        this.parameter = parameter;
        this.registersTable = registersTable;
    }

    public Register(int number, boolean parameter) {
        this(number, parameter, null);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public RegistersTable getRegistersTable() {
        return this.registersTable;
    }

    public int getValue() throws NullPointerException {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable == null) {
            throw new NullPointerException("Missing register table for: " + this.toString());
        }
        int value = registersTable.getRegisterValue(this);
        if (!this.isParameter()) {
            registersTable.ensureLocalRegistersCount(value + 1);
        }
        return value;
    }

    public char getSymbol() {
        if (this.isParameter()) {
            return 'p';
        }
        return 'v';
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getSymbol());
        writer.appendInteger(this.getNumber());
    }

    @Override
    public int compareTo(Register register) {
        return CompareUtil.compare(this.getValue(), register.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Register)) {
            return false;
        }
        Register register = (Register)obj;
        return this.getNumber() == register.getNumber() && this.isParameter() == register.isParameter();
    }

    public int hashCode() {
        int hash = 31;
        if (this.isParameter()) {
            ++hash;
        }
        hash = hash * 31 + this.getNumber();
        return hash;
    }

    public String toString() {
        return this.getSymbol() + Integer.toString(this.getNumber());
    }
}

