/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.StringsUtil;

public class AnnotationVisibility
extends Modifier {
    public static final AnnotationVisibility BUILD = new AnnotationVisibility(0, "build");
    public static final AnnotationVisibility RUNTIME = new AnnotationVisibility(1, "runtime");
    public static final AnnotationVisibility SYSTEM = new AnnotationVisibility(2, "system");
    private static final AnnotationVisibility[] VALUES = new AnnotationVisibility[]{BUILD, RUNTIME, SYSTEM};

    private AnnotationVisibility(int value, String name) {
        super(value, name);
    }

    @Override
    public boolean isSet(int value) {
        return value == this.getValue();
    }

    public static AnnotationVisibility valueOf(int visibility) {
        if (visibility < 0 || visibility >= VALUES.length) {
            return null;
        }
        return VALUES[visibility];
    }

    public static AnnotationVisibility valueOf(String visibility) {
        if ((visibility = StringsUtil.toLowercase(visibility)).equals("build")) {
            return BUILD;
        }
        if (visibility.equals("runtime")) {
            return RUNTIME;
        }
        if (visibility.equals("system")) {
            return SYSTEM;
        }
        return null;
    }

    public static AnnotationVisibility parse(SmaliReader reader) {
        reader.skipSpaces();
        int position = reader.position();
        int length = reader.indexOfWhiteSpace() - position;
        AnnotationVisibility visibility = AnnotationVisibility.valueOf(reader.readString(length));
        if (visibility == null) {
            reader.position(position);
        }
        return visibility;
    }
}

