/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.io.ByteReader;
import com.reandroid.dex.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;

public abstract class DexBlockItem
extends BlockItem
implements SectionTool {
    public DexBlockItem(int bytesLength) {
        super(bytesLength);
    }

    public static int writeUleb128(byte[] bytes, int offset, int value) {
        int index = 0;
        while (((long)value & 0xFFFFFFFFL) > 127L) {
            bytes[offset + index] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
            ++index;
        }
        bytes[offset + index] = (byte)value;
        return index + 1;
    }

    public static int readUleb128(InputStream inputStream) throws IOException {
        return DexBlockItem.readUleb128(StreamUtil.createByteReader(inputStream));
    }

    public static int readUleb128(byte[] bytes, int offset) throws IOException {
        return DexBlockItem.readUleb128(StreamUtil.createByteReader(bytes, offset));
    }

    public static int readUleb128(ByteReader reader) throws IOException {
        return DexBlockItem.readUleb128(reader, 4);
    }

    public static int readUleb128Large(ByteReader reader) throws IOException {
        return DexBlockItem.readUleb128(reader, 5);
    }

    public static int readUleb128(ByteReader reader, int size) throws IOException {
        int count;
        int result = 0;
        int value = 128;
        for (count = 0; value > 127 && count < size; ++count) {
            value = reader.read();
            result |= (value & 0x7F) << count * 7;
        }
        if (value > 127) {
            throw new IOException("Invalid uleb128 integer, size = " + size);
        }
        if (count > size && (value & 0xF) > 7) {
            throw new IOException("Encountered valid uleb128 that is out of range, size = " + size);
        }
        return result;
    }

    public static int readSleb128(ByteReader reader) throws IOException {
        int count;
        int value = 128;
        int result = 0;
        for (count = 0; value > 127 && count < 5; ++count) {
            value = reader.read();
            result |= (value & 0x7F) << count * 7;
        }
        if (count == 5 && value > 127) {
            throw new IOException("Invalid sleb128 integer");
        }
        int shift = 32 - count * 7;
        result = result << shift >> shift;
        return result;
    }

    public static int writeSleb128(byte[] bytes, int offset, int value) {
        int index = 0;
        if (value >= 0) {
            while (value > 63) {
                bytes[offset + index] = (byte)(value & 0x7F | 0x80);
                ++index;
                value >>>= 7;
            }
            bytes[offset + index] = (byte)(value & 0x7F);
            ++index;
        } else {
            while (value < -64) {
                bytes[offset + index] = (byte)(value & 0x7F | 0x80);
                ++index;
                value >>= 7;
            }
            bytes[offset + index] = (byte)(value & 0x7F);
            ++index;
        }
        return index;
    }

    protected static long getSignedNumber(byte[] bytes, int offset, int size) {
        int index;
        if (offset + size > bytes.length) {
            return 0L;
        }
        long result = 0L;
        int high = bytes[index] & 0xFF;
        for (index = offset + size - 1; index >= offset; --index) {
            result <<= 8;
            result |= (long)(bytes[index] & 0xFF);
        }
        if (high > 127) {
            long max = -1L >>> 64 - size * 8;
            result -= max;
            --result;
        }
        return result;
    }
}

