/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import com.reandroid.commons.utils.ElapsedTime;
import com.reandroid.commons.utils.log.ConsoleUtil;
import com.reandroid.commons.utils.log.FileLogger;
import com.reandroid.commons.utils.log.StdLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class Logger {
    private static Logger sInstance;
    private final ElapsedTime elapsedTime = new ElapsedTime();
    private final ElapsedTime logTime = new ElapsedTime();
    private final ElapsedTime widthCheckTime = new ElapsedTime();
    private final List<Logger> subLoggers = new ArrayList<Logger>();
    private boolean hideTime;
    private boolean enable = true;
    private int mConsoleWidth;
    private static final String TYPE_INFO = "I";
    private static final String TYPE_WARN = "W";
    private static final String TYPE_ERROR = "E";
    private static final String TRACE_TAB1 = "    ";
    private static final String TRACE_TAB2 = "        ";
    private static final int MAX_TRACE = 10;
    private static final long INTERVAL = 2000L;
    private static final long UPDATE_CONSOLE_INTERVAL = 4000L;

    Logger() {
    }

    public void every2Second(String msg) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.logTime.isExpired(2000L)) {
            return;
        }
        this.logTime.reset();
        StringBuilder line = this.buildLine(null, msg);
        this.writeLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.info(msg);
        }
    }

    public void every2SecondSameLine(String msg) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.logTime.isExpired(2000L)) {
            return;
        }
        this.logTime.reset();
        StringBuilder line = this.buildLine(null, msg);
        this.writeSameLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.writeSameLine(msg);
        }
    }

    public void onSameLine(String msg) {
        if (!this.isEnable()) {
            return;
        }
        StringBuilder line = this.buildLine(null, msg);
        this.writeSameLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.onSameLine(msg);
        }
    }

    public void info(String msg) {
        if (!this.isEnable()) {
            return;
        }
        StringBuilder line = this.buildLine(TYPE_INFO, msg);
        this.writeLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.info(msg);
        }
    }

    public void warn(String msg) {
        if (!this.isEnable()) {
            return;
        }
        StringBuilder line = this.buildLine(TYPE_WARN, msg);
        this.writeLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.warn(msg);
        }
    }

    public void error(String msg) {
        if (!this.isEnable()) {
            return;
        }
        StringBuilder line = this.buildLine(TYPE_ERROR, msg);
        this.writeLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.error(msg);
        }
    }

    public void error(Throwable tr) {
        if (!this.isEnable()) {
            return;
        }
        this.error(null, tr);
    }

    public void error(String msg, Throwable tr) {
        if (!this.isEnable()) {
            return;
        }
        StringBuilder line = msg != null ? this.buildLine(TYPE_ERROR, msg) : new StringBuilder();
        if (tr != null) {
            if (msg == null) {
                line = this.buildLine(TYPE_ERROR, tr.getClass().getName() + " " + tr.getMessage());
            } else {
                line.append(' ').append(tr.getClass().getSimpleName()).append(' ').append(tr.getMessage());
            }
            this.appendStackTraces(line, tr);
        }
        this.writeLine(line.toString());
        for (Logger sub : this.subLoggers) {
            sub.error(msg, tr);
        }
    }

    public void addSubLogger(Logger logger) {
        if (logger == null || logger == this) {
            return;
        }
        if (!this.subLoggers.contains(logger)) {
            this.subLoggers.add(logger);
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.setEnable(enable, false);
    }

    public void setEnable(boolean enable, boolean setSubLoggers) {
        this.enable = enable;
        if (setSubLoggers) {
            for (Logger sub : this.subLoggers) {
                sub.setEnable(enable, true);
            }
        }
    }

    public boolean isHideTime() {
        return this.hideTime;
    }

    public void setHideTime(boolean hide) {
        this.hideTime = hide;
    }

    private void appendStackTraces(StringBuilder builder, Throwable tr) {
        StackTraceElement[] elements = tr.getStackTrace();
        this.appendStackTraces(builder, elements);
        Throwable cause = tr.getCause();
        if (cause == null) {
            return;
        }
        builder.append('\n').append(TRACE_TAB1).append("Caused by: ");
        builder.append(cause.getClass().getSimpleName());
        builder.append(' ').append(cause.getMessage());
        elements = cause.getStackTrace();
        this.appendStackTraces(builder, elements);
    }

    private void appendStackTraces(StringBuilder builder, StackTraceElement[] traceElements) {
        if (traceElements == null) {
            return;
        }
        int len = traceElements.length;
        if (len > 10) {
            len = 10;
        }
        for (int i = 0; i < len; ++i) {
            StackTraceElement element = traceElements[i];
            this.appendStackTrace(builder, element);
        }
    }

    private void appendStackTrace(StringBuilder builder, StackTraceElement element) {
        if (element == null) {
            return;
        }
        builder.append('\n');
        builder.append(TRACE_TAB2);
        builder.append("at ").append(element.toString());
    }

    private StringBuilder buildLine(String type, String msg) {
        StringBuilder builder = new StringBuilder();
        boolean hide = this.isHideTime();
        if (!hide) {
            builder.append(this.elapsedTime.now());
            builder.append(' ');
        }
        if (type != null) {
            builder.append(type).append(':').append(' ');
        }
        builder.append(msg);
        return builder;
    }

    public abstract void writeLine(String var1);

    public abstract void writeSameLine(String var1);

    public static void i(String msg) {
        Logger.getLogger().info(msg);
    }

    public static void w(String msg) {
        Logger.getLogger().warn(msg);
    }

    public static void e(String msg) {
        Logger.getLogger().error(msg);
    }

    public static void e(Throwable tr) {
        Logger.getLogger().error(tr);
    }

    public static void e(String msg, Throwable tr) {
        Logger.getLogger().error(msg, tr);
    }

    public static void sameLine(String msg) {
        Logger.getLogger().onSameLine(msg);
    }

    public static void timely(String msg) {
        Logger.getLogger().every2Second(msg);
    }

    public static void timelySameLine(String msg) {
        Logger.getLogger().every2SecondSameLine(msg);
    }

    int checkConsoleWidth() {
        if (this.mConsoleWidth == 0) {
            this.updateConsoleWidth();
            return this.mConsoleWidth;
        }
        Boolean succeedOnce = ConsoleUtil.getSucceedOnce();
        if (succeedOnce != null && !succeedOnce.booleanValue()) {
            return this.mConsoleWidth;
        }
        if (this.widthCheckTime.isExpired(4000L)) {
            this.updateConsoleWidth();
        }
        return this.mConsoleWidth;
    }

    private void updateConsoleWidth() {
        this.widthCheckTime.reset();
        this.mConsoleWidth = ConsoleUtil.getConsoleWidth();
        if (this.mConsoleWidth <= 0) {
            this.mConsoleWidth = 80;
        }
    }

    public static void clearFileLoggers() {
        Logger logger = Logger.getLogger();
        ArrayList<Logger> subList = new ArrayList<Logger>(logger.subLoggers);
        for (Logger sub : subList) {
            if (!(sub instanceof FileLogger)) continue;
            FileLogger fileLogger = (FileLogger)sub;
            fileLogger.onShutdown();
            logger.subLoggers.remove(fileLogger);
        }
    }

    public static void addFileLogger(File file) {
        FileLogger fileLogger = FileLogger.create(file);
        Logger.getLogger().addSubLogger(fileLogger);
    }

    public static void enableStdLogger(boolean enable) {
        Logger logger = Logger.getLogger();
        logger.setEnable(enable, false);
        for (Logger sub : logger.subLoggers) {
            if (sub instanceof StdLogger) continue;
            sub.setEnable(enable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            sInstance = StdLogger.getInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }
}

