/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConsoleUtil {
    private static final boolean IS_WINDOWS;
    private static final int DEFAULT_WIDTH;
    private static Boolean succeedOnce;
    private static boolean issue_logged;

    public static int getConsoleWidth() {
        if (IS_WINDOWS) {
            try {
                return ConsoleUtil.attemptMode();
            }
            catch (Throwable ignored) {
                succeedOnce = false;
            }
        } else {
            try {
                return ConsoleUtil.attemptStty();
            }
            catch (Exception ex) {
                succeedOnce = false;
            }
        }
        return DEFAULT_WIDTH;
    }

    public static boolean isConsole() {
        Boolean succeed = succeedOnce;
        if (succeed == null) {
            ConsoleUtil.getConsoleWidth();
            succeed = succeedOnce;
        }
        return succeed != null && succeed != false;
    }

    public static Boolean getSucceedOnce() {
        return succeedOnce;
    }

    private static int attemptStty() {
        String output = ConsoleUtil.attemptCommand(new String[]{"sh", "-c", "stty size < /dev/tty"});
        if (output == null) {
            succeedOnce = false;
            return DEFAULT_WIDTH;
        }
        String[] vals = output.trim().split(" ");
        if (vals.length < 2) {
            ConsoleUtil.logWidthIssue(output);
            succeedOnce = false;
            return DEFAULT_WIDTH;
        }
        try {
            int result = Integer.parseInt(vals[1]);
            if (result > 0) {
                if (succeedOnce == null || !succeedOnce.booleanValue()) {
                    succeedOnce = true;
                }
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ConsoleUtil.logWidthIssue(output);
        succeedOnce = false;
        return DEFAULT_WIDTH;
    }

    private static int attemptMode() {
        int result;
        String output = ConsoleUtil.attemptCommand(new String[]{"mode", "con"});
        if (output == null) {
            succeedOnce = false;
            return DEFAULT_WIDTH;
        }
        Pattern pattern = Pattern.compile("Columns:\\S*(\\d+)");
        Matcher m = pattern.matcher(output);
        if (m.find() && (result = Integer.parseInt(m.group(1))) > 0) {
            if (succeedOnce == null || !succeedOnce.booleanValue()) {
                succeedOnce = true;
            }
            return result;
        }
        ConsoleUtil.logWidthIssue(output);
        succeedOnce = false;
        return DEFAULT_WIDTH;
    }

    public static String attemptCommand(String[] command) {
        StringBuffer buffer = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                buffer.append(line);
            }
            if (buffer != null) {
                return buffer.toString();
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static void logWidthIssue(String output) {
        if (issue_logged) {
            return;
        }
        issue_logged = true;
        String msg = "Failed to parse console width\nPlease create issue at https://github.com/REAndroid/APKEditor\nos.name=" + System.getProperty("os.name") + "\nCommand output=" + output;
        System.err.println(msg);
    }

    static {
        String str = System.getProperty("os.name");
        if (str == null) {
            str = "";
        }
        IS_WINDOWS = str.toLowerCase().contains("windows");
        DEFAULT_WIDTH = 80;
    }
}

