/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

public class TextPosition {
    private int lineNumber;
    private int columnNumber;
    private String description;

    public TextPosition(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public TextPosition() {
        this(-1, -1);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = this.getLineNumber();
        if (i == -1) {
            builder.append("--");
        } else {
            builder.append(" line=");
            builder.append(i);
        }
        i = this.getColumnNumber();
        if (i == -1) {
            builder.append("--");
        } else {
            builder.append(" column=");
            builder.append(i);
        }
        builder.append(']');
        String description = this.getDescription();
        if (description != null) {
            builder.append(' ');
            builder.append(description);
        }
        return builder.toString();
    }
}

