/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.utils.StringsUtil;

public class Origin {
    private Origin parent;
    private final Object name;
    private Object separator = ":";

    public Origin(Origin parent, Object name) {
        this.parent = parent;
        this.name = name;
    }

    public Object getName() {
        return this.name;
    }

    public Origin getParent() {
        return this.parent;
    }

    public void setParent(Origin parent) {
        this.parent = parent;
    }

    public void setSeparator(Object separator) {
        this.separator = separator;
    }

    public Object getSeparator() {
        Object separator = this.separator;
        if (separator == null) {
            separator = StringsUtil.EMPTY;
        }
        return separator;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Origin[] toArray() {
        int count = 0;
        Origin source = this;
        while (!source.isRoot()) {
            ++count;
            source = source.getParent();
        }
        Origin[] result = new Origin[count];
        --count;
        source = this;
        while (count >= 0) {
            result[count] = source;
            source = source.getParent();
            --count;
        }
        return result;
    }

    public Origin createChild(Object name) {
        return new Origin(this, name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Origin[] sources = this.toArray();
        int length = sources.length;
        for (int i = 0; i < length; ++i) {
            Origin source = sources[i];
            if (i != 0) {
                builder.append(source.getSeparator());
            }
            builder.append(source.getName());
        }
        return builder.toString();
    }

    public static Origin newRoot() {
        return new Origin(null, StringsUtil.EMPTY);
    }

    public static Origin createNew(Object name) {
        return Origin.newRoot().createChild(name);
    }
}

