/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.style;

import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.bag.MapBag;
import com.reandroid.arsc.value.style.StyleBagItem;
import com.reandroid.xml.XMLUtil;
import java.util.List;

public class StyleBag
extends MapBag<Integer, StyleBagItem> {
    private StyleBag(Entry entry) {
        super(entry);
    }

    public String getParentResourceName() {
        int id = this.getParentId();
        if (id == 0) {
            return null;
        }
        Entry entry = this.getEntry();
        if (entry == null) {
            return null;
        }
        ResTableMapEntry tableMapEntry = entry.getResTableMapEntry();
        if (tableMapEntry != null) {
            return tableMapEntry.decodeParentId();
        }
        return null;
    }

    public int getParentId() {
        return this.getTableEntry().getParentId();
    }

    public void setParentId(int id) {
        this.getTableEntry().setParentId(id);
    }

    public int getResourceId() {
        Entry entry = this.getEntry();
        if (entry == null) {
            return 0;
        }
        return entry.getResourceId();
    }

    @Override
    protected StyleBagItem createBagItem(ResValueMap valueMap, boolean copied) {
        if (copied) {
            return StyleBagItem.copyOf(valueMap);
        }
        return StyleBagItem.create(valueMap);
    }

    @Override
    protected ResValueMap newKey(Integer attrId) {
        ResValueMap valueMap = new ResValueMap();
        valueMap.setParent(this.getMapArray());
        valueMap.setNameId(attrId);
        return valueMap;
    }

    @Override
    protected Integer getKeyFor(ResValueMap valueMap) {
        return valueMap.getNameId();
    }

    public static int resolve(TableBlock tableBlock, String name) {
        return tableBlock.getAttrResource(XMLUtil.splitPrefix(name), XMLUtil.splitName(name)).getResourceId();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        String type = this.getTypeName();
        builder.append(type);
        builder.append(" name=\"");
        builder.append(this.getName());
        builder.append("\"");
        String parent = this.getParentResourceName();
        if (parent != null) {
            builder.append(" parent=\"");
            builder.append(parent);
            builder.append("\"");
        }
        builder.append("\">");
        for (StyleBagItem item : this.values()) {
            builder.append("\n    ");
            builder.append(item.toString());
        }
        builder.append("\n</");
        builder.append(type);
        builder.append(">");
        return builder.toString();
    }

    public static boolean isStyle(Entry entry) {
        StyleBag style = StyleBag.create(entry);
        if (style == null) {
            return false;
        }
        TableBlock tableBlock = entry.getPackageBlock().getTableBlock();
        if (tableBlock == null) {
            return false;
        }
        List list = style.getMapArray().getChildes();
        if (list.size() == 0) {
            return false;
        }
        for (ResValueMap item : list) {
            if (item != null && tableBlock.getResource(item.getNameId()) != null) continue;
            return false;
        }
        return true;
    }

    public static StyleBag create(Entry entry) {
        if (entry == null || !entry.isComplex()) {
            return null;
        }
        return new StyleBag(entry);
    }
}

