/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.graphics.AndroidColor;
import com.reandroid.utils.StringsUtil;
import java.util.HashMap;
import java.util.Map;

public enum ValueType {
    NULL(0, ""),
    REFERENCE(1, "reference"),
    ATTRIBUTE(2, "reference"),
    FLOAT(4, "float"),
    DIMENSION(5, "dimension"),
    FRACTION(6, "fraction"),
    DEC(16, "integer"),
    HEX(17, "integer"),
    BOOLEAN(18, "bool"),
    COLOR_ARGB8(28, "color"),
    COLOR_RGB8(29, "color"),
    COLOR_ARGB4(30, "color"),
    COLOR_RGB4(31, "color"),
    STRING(3, "string"),
    DYNAMIC_REFERENCE(7, "reference"),
    DYNAMIC_ATTRIBUTE(8, "reference");

    private final byte mByte;
    private final String typeName;
    private static ValueType[] sortedValues;
    private static Map<String, ValueType> valueTypeMap;

    private ValueType(byte b, String typeName) {
        this.mByte = b;
        this.typeName = typeName;
    }

    public byte getByte() {
        return this.mByte;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isColor() {
        return this == COLOR_ARGB8 || this == COLOR_RGB8 || this == COLOR_ARGB4 || this == COLOR_RGB4;
    }

    public boolean isInteger() {
        return this == DEC || this == HEX;
    }

    public boolean isReference() {
        return this == REFERENCE || this == ATTRIBUTE || this == DYNAMIC_REFERENCE || this == DYNAMIC_ATTRIBUTE;
    }

    public static ValueType valueOf(byte b) {
        return ValueType.valueOf(b & 0xFF);
    }

    public static ValueType valueOf(int i) {
        if (i < 0) {
            return null;
        }
        ValueType[] sorted = ValueType.getSortedValues();
        if (i < sorted.length) {
            return sorted[i];
        }
        return null;
    }

    public static ValueType fromName(String name) {
        return ValueType.getValueTypeMap().get(StringsUtil.toUpperCase(name));
    }

    public static AndroidColor.Type colorType(ValueType valueType) {
        if (valueType == COLOR_RGB4) {
            return AndroidColor.Type.RGB4;
        }
        if (valueType == COLOR_ARGB4) {
            return AndroidColor.Type.ARGB4;
        }
        if (valueType == COLOR_RGB8) {
            return AndroidColor.Type.RGB8;
        }
        if (valueType == COLOR_ARGB8) {
            return AndroidColor.Type.ARGB8;
        }
        return null;
    }

    public static ValueType colorType(AndroidColor.Type type) {
        if (type == AndroidColor.Type.RGB4) {
            return COLOR_RGB4;
        }
        if (type == AndroidColor.Type.ARGB4) {
            return COLOR_ARGB4;
        }
        if (type == AndroidColor.Type.RGB8) {
            return COLOR_RGB8;
        }
        if (type == AndroidColor.Type.ARGB8) {
            return COLOR_ARGB8;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueType[] getSortedValues() {
        if (sortedValues != null) {
            return sortedValues;
        }
        Class<ValueType> clazz = ValueType.class;
        synchronized (ValueType.class) {
            ValueType[] values;
            ValueType[] sorted = new ValueType[32];
            ValueType[] valueTypeArray = values = ValueType.values();
            int n = valueTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ValueType valueType;
                sorted[valueType.getByte() & 0xFF] = valueType = valueTypeArray[i];
            }
            sortedValues = sorted;
            // ** MonitorExit[var0] (shouldn't be in output)
            return sorted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ValueType> getValueTypeMap() {
        if (valueTypeMap != null) {
            return valueTypeMap;
        }
        Class<ValueType> clazz = ValueType.class;
        synchronized (ValueType.class) {
            ValueType[] values;
            HashMap<String, ValueType> map = new HashMap<String, ValueType>();
            for (ValueType valueType : values = ValueType.values()) {
                map.put(valueType.name(), valueType);
            }
            valueTypeMap = map;
            // ** MonitorExit[var0] (shouldn't be in output)
            return map;
        }
    }
}

