/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.value.LocaleDataTables;
import com.reandroid.arsc.value.LocaleUtil;
import java.util.Arrays;

public class LocaleData {
    public static final int[] ENGLISH_STOP_LIST = new int[]{1701707776, 1701741568};
    public static final char[] ENGLISH_CHARS = new char[]{'e', 'n'};
    public static final char[] LATIN_CHARS = new char[]{'L', 'a', 't', 'n'};
    public static int SCRIPT_LENGTH = 4;
    public static int US_SPANISH = 1702057299;
    public static int MEXICAN_SPANISH = 1702055256;
    public static int LATIN_AMERICAN_SPANISH = 1702077476;
    static final int SCRIPT_PARENTS_COUNT = LocaleDataTables.SCRIPT_PARENTS.length;
    static final int PACKED_ROOT = 0;

    public static int packLocale(char[] language, char[] region) {
        return language[0] << 24 | language[1] << 16 | region[0] << 8 | region[1];
    }

    public static int dropRegion(int packed_locale) {
        return packed_locale & 0xFFFF0000;
    }

    public static boolean hasRegion(int packed_locale) {
        return (packed_locale & 0xFFFF) != 0;
    }

    public static int findParent(int packed_locale, char[] script) {
        LocaleDataTables.ScriptParent[] SCRIPT_PARENTS = LocaleDataTables.SCRIPT_PARENTS;
        if (LocaleData.hasRegion(packed_locale)) {
            for (int i = 0; i < SCRIPT_PARENTS_COUNT; ++i) {
                if (!Arrays.equals(script, SCRIPT_PARENTS[i].script)) continue;
                int[] lookup_result = LocaleUtil.find(SCRIPT_PARENTS[i].map, packed_locale);
                if (lookup_result == null) break;
                return lookup_result[1];
            }
            return LocaleData.dropRegion(packed_locale);
        }
        return 0;
    }

    public static int findAncestors(int[] out, int[] stop_list_index, int packed_locale, char[] script, int[] stop_list, int stop_set_length) {
        int ancestor = packed_locale;
        int count = 0;
        do {
            if (out != null) {
                out[count] = ancestor;
            }
            ++count;
            for (int i = 0; i < stop_set_length; ++i) {
                if (stop_list[i] != ancestor) continue;
                stop_list_index[0] = i;
                return count;
            }
        } while ((ancestor = LocaleData.findParent(ancestor, script)) != 0);
        stop_list_index[0] = -1;
        return count;
    }

    public static int findDistance(int supported, char[] script, int[] request_ancestors, int request_ancestors_count) {
        int[] request_ancestors_index = new int[1];
        int supported_ancestor_count = LocaleData.findAncestors(null, request_ancestors_index, supported, script, request_ancestors, request_ancestors_count);
        return supported_ancestor_count + request_ancestors_index[0] - 1;
    }

    public static boolean isRepresentative(int language_and_region, char[] script) {
        long packed_locale = (long)language_and_region << 32 | (long)script[0] << 24 | (long)script[1] << 16 | (long)script[2] << 8 | (long)script[3];
        return LocaleUtil.contains(LocaleDataTables.REPRESENTATIVE_LOCALES, packed_locale);
    }

    public static boolean isSpecialSpanish(int language_and_region) {
        return language_and_region == US_SPANISH || language_and_region == MEXICAN_SPANISH;
    }

    public static int localeDataCompareRegions(char[] left_region, char[] right_region, char[] requested_language, char[] requested_script, char[] requested_region) {
        boolean right_is_representative;
        int right_distance;
        if (left_region[0] == right_region[0] && left_region[1] == right_region[1]) {
            return 0;
        }
        int left = LocaleData.packLocale(requested_language, left_region);
        int right = LocaleData.packLocale(requested_language, right_region);
        int request = LocaleData.packLocale(requested_language, requested_region);
        boolean leftIsSpecialSpanish = LocaleData.isSpecialSpanish(left);
        boolean rightIsSpecialSpanish = LocaleData.isSpecialSpanish(right);
        if (leftIsSpecialSpanish && !rightIsSpecialSpanish && right != LATIN_AMERICAN_SPANISH) {
            left = LATIN_AMERICAN_SPANISH;
        } else if (rightIsSpecialSpanish && !leftIsSpecialSpanish && left != LATIN_AMERICAN_SPANISH) {
            right = LATIN_AMERICAN_SPANISH;
        }
        int[] request_ancestors = new int[4];
        int[] left_right_index = new int[]{};
        int[][] left_and_right = new int[][]{{left, right}};
        int ancestor_count = LocaleData.findAncestors(request_ancestors, left_right_index, request, requested_script, left_and_right[0], left_and_right.length);
        if (left_right_index[0] == 0) {
            return 1;
        }
        if (left_right_index[0] == 1) {
            return -1;
        }
        int left_distance = LocaleData.findDistance(left, requested_script, request_ancestors, ancestor_count);
        if (left_distance != (right_distance = LocaleData.findDistance(right, requested_script, request_ancestors, ancestor_count))) {
            return right_distance - left_distance;
        }
        boolean left_is_representative = LocaleData.isRepresentative(left, requested_script);
        if (left_is_representative != (right_is_representative = LocaleData.isRepresentative(right, requested_script))) {
            return (left_is_representative ? 1 : 0) - (right_is_representative ? 1 : 0);
        }
        return (int)(((long)right & 0xFFFFFFFF00000000L) - ((long)left & 0xFFFFFFFF00000000L));
    }

    public static void localeDataComputeScript(char[] out, char[] language, char[] region) {
        if (language[0] == '\u0000') {
            LocaleUtil.memset(out, '\u0000', SCRIPT_LENGTH);
            return;
        }
        int lookup_key = LocaleData.packLocale(language, region);
        int[] lookup_result = LocaleUtil.find(LocaleDataTables.LIKELY_SCRIPTS, lookup_key);
        if (lookup_result == null) {
            if (region[0] != '\u0000' && (lookup_result = LocaleUtil.find(LocaleDataTables.LIKELY_SCRIPTS, lookup_key = LocaleData.dropRegion(lookup_key))) != null) {
                LocaleUtil.memcpy(out, LocaleDataTables.SCRIPT_CODES[lookup_result[1]], SCRIPT_LENGTH);
                return;
            }
            LocaleUtil.memset(out, '\u0000', SCRIPT_LENGTH);
            return;
        }
        LocaleUtil.memcpy(out, LocaleDataTables.SCRIPT_CODES[lookup_result[1]], SCRIPT_LENGTH);
    }

    public static boolean localeDataIsCloseToUsEnglish(char[] region) {
        int locale = LocaleData.packLocale(ENGLISH_CHARS, region);
        int[] stop_list_index = new int[1];
        LocaleData.findAncestors(null, stop_list_index, locale, LATIN_CHARS, ENGLISH_STOP_LIST, 2);
        return stop_list_index[0] == 0;
    }
}

