/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;

public class ResourceName
implements Comparable<ResourceName> {
    private String packageName;
    private final String type;
    private final String name;

    public ResourceName(String packageName, String type, String name) {
        this.packageName = packageName;
        this.type = type;
        this.name = name;
    }

    public ResourceName(String type, String name) {
        this(null, type, name);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (StringsUtil.isEmpty(packageName)) {
            packageName = null;
        }
        this.packageName = packageName;
    }

    public boolean matchesPackageName(String packageName) {
        String p = this.getPackageName();
        if (p == null || StringsUtil.isEmpty(packageName)) {
            return true;
        }
        return p.equals(packageName);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String buildReference(boolean attribute, String packageContext) {
        String packageName = this.getPackageName();
        boolean appendPackage = packageContext != null && packageName != null && !packageName.equals(packageContext);
        return this.buildReference((Boolean)attribute, appendPackage);
    }

    public String buildReference(Boolean attribute, boolean appendPackage) {
        String packageName;
        StringBuilder builder = new StringBuilder();
        if (attribute != null) {
            if (attribute.booleanValue()) {
                builder.append('?');
            } else {
                builder.append('@');
            }
        }
        if (appendPackage && (packageName = this.getPackageName()) != null) {
            builder.append(packageName);
            builder.append(':');
        }
        builder.append(this.getType());
        builder.append('/');
        builder.append(this.getName());
        return builder.toString();
    }

    @Override
    public int compareTo(ResourceName resourceName) {
        if (resourceName == this) {
            return 0;
        }
        int i = CompareUtil.compare(this.getPackageName(), resourceName.getPackageName());
        if (i == 0) {
            i = CompareUtil.compare(this.getType(), resourceName.getType());
        }
        if (i == 0) {
            i = CompareUtil.compare(this.getName(), resourceName.getName());
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceName)) {
            return false;
        }
        ResourceName that = (ResourceName)obj;
        String p1 = this.getPackageName();
        String p2 = that.getPackageName();
        if (p1 != null && p2 != null && !p1.equals(p2)) {
            return false;
        }
        return ObjectsUtil.equals(this.getType(), that.getType()) && ObjectsUtil.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getType(), this.getName());
    }

    public String toString() {
        return this.buildReference((Boolean)false, true);
    }

    public static ResourceName parse(String reference) {
        return ResourceName.from(ReferenceString.parseReference(reference));
    }

    public static ResourceName from(ReferenceString referenceString) {
        if (referenceString != null) {
            return new ResourceName(referenceString.packageName, referenceString.type, referenceString.name);
        }
        return null;
    }
}

