/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.OffsetItem;
import com.reandroid.arsc.list.OffsetReferenceList;
import java.io.IOException;

public class OffsetBlockList<T extends Block>
extends BlockList<T> {
    private final IntegerReference start;
    private final OffsetReferenceList<?> offsetReferenceList;

    public OffsetBlockList(IntegerReference start, OffsetReferenceList<?> offsetReferenceList, Creator<? extends T> creator) {
        super(creator);
        this.start = start;
        this.offsetReferenceList = offsetReferenceList;
    }

    public OffsetBlockList(IntegerReference start, OffsetReferenceList<?> offsetReferenceList) {
        this.start = start;
        this.offsetReferenceList = offsetReferenceList;
    }

    public IntegerReference getStart() {
        return this.start;
    }

    public IntegerReference getCountReference() {
        return this.getOffsetReferenceList().getCountReference();
    }

    public OffsetReferenceList<?> getOffsetReferenceList() {
        return this.offsetReferenceList;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.clearChildes();
    }

    public AlignItem getAlignment() {
        return null;
    }

    private void updateCountReference() {
        this.getOffsetReferenceList().setSize(this.size());
    }

    private void updateStartReference() {
        this.updateCountReference();
        Block parent = this.getParent();
        int start = 0;
        if (parent != null && !this.isEmpty()) {
            start = parent.countUpTo(this);
        }
        this.getStart().set(start);
    }

    public int buildOffsetList() {
        this.updateStartReference();
        OffsetReferenceList<?> referenceList = this.getOffsetReferenceList();
        int size = this.size();
        referenceList.setSize(size);
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            offset = ((OffsetItem)referenceList.get(i)).updateOffset((Block)this.get(i), offset);
        }
        AlignItem alignment = this.getAlignment();
        if (alignment != null) {
            offset += alignment.align(offset);
        }
        return offset;
    }

    @Override
    public void setSize(int size, boolean notify) {
        super.setSize(size, true);
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.updateCountReference();
    }

    @Override
    protected void refreshChildes() {
        int size = this.size();
        if (size != 0 && this.get(0) instanceof BlockRefresh) {
            for (int i = 0; i < size; ++i) {
                ((BlockRefresh)this.get(i)).refresh();
            }
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.buildOffsetList();
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        if (this.getOffsetReferenceList().size() != 0) {
            int position = this.getStart().get();
            reader.seek(position);
            BlockReader listReader = reader.create(reader.available());
            this.readChildes(listReader);
            listReader.close();
            reader.seek(position += listReader.getPosition());
        }
    }

    @Override
    public void readChildes(BlockReader reader) throws IOException {
        OffsetReferenceList<?> referenceList = this.getOffsetReferenceList();
        int size = referenceList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((OffsetItem)referenceList.get(i)).readTarget(reader, (Block)this.get(i));
        }
    }
}

