/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.utils.HexUtil;

public class TypeString
extends StringItem {
    public TypeString(boolean utf8) {
        super(utf8);
    }

    public boolean isTypeAttr() {
        return TypeString.isTypeAttr(this.get());
    }

    public boolean isTypeId() {
        return TypeString.isTypeId(this.get());
    }

    public int getId() {
        TypeStringPool stringPool = this.getParent(TypeStringPool.class);
        if (stringPool != null) {
            return stringPool.idOf(this);
        }
        return this.getIndex() + 1;
    }

    @Override
    public StyleItem getOrCreateStyle() {
        return null;
    }

    @Override
    void ensureStringLinkUnlocked() {
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        return Integer.compare(this.getIndex(), stringItem.getIndex());
    }

    @Override
    public String toString() {
        return HexUtil.toHex2((byte)this.getId()) + ':' + this.get();
    }

    public static boolean isTypeAttr(String type) {
        if (type == null) {
            return false;
        }
        return type.contains("attr");
    }

    public static boolean isTypeArray(String type) {
        if (type == null) {
            return false;
        }
        return type.contains("array");
    }

    public static boolean isTypeStyle(String type) {
        if (type == null) {
            return false;
        }
        return type.contains("style");
    }

    public static boolean isTypePlurals(String type) {
        if (type == null) {
            return false;
        }
        return type.contains("plurals");
    }

    public static boolean isTypeId(String type) {
        return "id".equals(type);
    }

    public static boolean isTypeString(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("string");
    }

    public static String toXmlTagName(String typeName) {
        if (typeName != null && typeName.length() > 0 && typeName.charAt(0) == '^') {
            typeName = typeName.substring(1);
        }
        return typeName;
    }
}

