/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsStore;
import java.util.Iterator;

public class ResXmlID
extends IntegerItem
implements Comparable<ResXmlID> {
    private Object mReferencedList;
    private ResXmlString mResXmlString;
    public static final Creator<ResXmlID> CREATOR = ResXmlID::new;

    public void addReference(ReferenceItem reference) {
        this.mReferencedList = ObjectsStore.add(this.mReferencedList, reference);
    }

    public void removeReference(ReferenceItem reference) {
        this.mReferencedList = ObjectsStore.remove(this.mReferencedList, reference);
    }

    public int getReferenceCount() {
        return ObjectsStore.size(this.mReferencedList);
    }

    public boolean hasReference() {
        return !ObjectsStore.isEmpty(this.mReferencedList);
    }

    public boolean hasReference(Block block) {
        if (block != null) {
            Iterator iterator = ObjectsStore.iterator(this.mReferencedList);
            while (iterator.hasNext()) {
                ReferenceItem item = (ReferenceItem)iterator.next();
                if (item.getReferredParent(block.getClass()) != block) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        ResXmlString xmlString = this.getResXmlString();
        if (xmlString == null) {
            return null;
        }
        return xmlString.getHtml();
    }

    public ResXmlString getResXmlString() {
        ResXmlString resXmlString = this.mResXmlString;
        if (resXmlString == null || resXmlString.getParent() == null) {
            return null;
        }
        return resXmlString;
    }

    void setResXmlStringInternal(ResXmlString xmlString) {
        this.mResXmlString = xmlString;
    }

    public boolean isEmpty() {
        ResXmlString stringItem = this.getResXmlString();
        if (stringItem == null) {
            return true;
        }
        return this.get() == 0;
    }

    @Override
    public int compareTo(ResXmlID resXmlID) {
        ResXmlString xmlString2;
        if (resXmlID == null) {
            return -1;
        }
        if (resXmlID == this) {
            return 0;
        }
        ResXmlString xmlString1 = this.getResXmlString();
        int i = CompareUtil.compare(xmlString1 == null, (xmlString2 = resXmlID.getResXmlString()) == null);
        if (i != 0) {
            return i;
        }
        if (xmlString1 == null || xmlString2 == null) {
            return 0;
        }
        return CompareUtil.compare(xmlString1.getIndex(), xmlString2.getIndex());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("USED-BY=");
        builder.append(this.getReferenceCount());
        builder.append('{');
        String name = this.getName();
        if (name != null) {
            builder.append(name);
        } else {
            builder.append(this.getIndex());
        }
        builder.append(':');
        builder.append(HexUtil.toHex8(this.get()));
        builder.append('}');
        return builder.toString();
    }
}

