/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.LongReference;
import com.reandroid.utils.HexUtil;

public class LongItem
extends BlockItem
implements LongReference,
DirectStreamReader {
    private final boolean bigEndian;
    private long mCache;
    public static final Creator<LongItem> CREATOR = () -> new LongItem(false);
    public static final Creator<LongItem> CREATOR_BIG_ENDIAN = () -> new LongItem(true);

    public LongItem(boolean bigEndian) {
        super(8);
        this.bigEndian = bigEndian;
    }

    public LongItem() {
        this(false);
    }

    @Override
    public void set(long value) {
        if (value == this.mCache) {
            return;
        }
        this.mCache = value;
        byte[] bytes = this.getBytesInternal();
        if (this.bigEndian) {
            LongItem.putBigEndianLong(bytes, 0, value);
        } else {
            LongItem.putLong(bytes, 0, value);
        }
    }

    @Override
    public long getLong() {
        return this.mCache;
    }

    @Override
    public int get() {
        return (int)this.getLong();
    }

    @Override
    public void set(int value) {
        this.set((long)value & 0xFFFFFFFFL);
    }

    public String toHex() {
        return HexUtil.toHex(this.getLong(), 16);
    }

    @Override
    protected void onBytesChanged() {
        byte[] bytes = this.getBytesInternal();
        long l = this.bigEndian ? LongItem.getBigEndianLong(bytes, 0) : LongItem.getLong(bytes, 0);
        this.mCache = l;
    }

    public String toString() {
        return String.valueOf(this.getLong());
    }
}

