/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.utils.CompareUtil;
import java.nio.charset.StandardCharsets;

public class FixedLengthString
extends StringItem {
    private final int bytesLength;

    public FixedLengthString(int bytesLength) {
        super(true);
        this.bytesLength = bytesLength;
        this.setBytesLength(bytesLength);
    }

    @Override
    protected byte[] encodeString(String text) {
        if (text == null) {
            return new byte[this.bytesLength];
        }
        byte[] bytes = FixedLengthString.getUtf16Bytes(text);
        byte[] results = new byte[this.bytesLength];
        int length = bytes.length;
        if (length > this.bytesLength) {
            length = this.bytesLength;
        }
        System.arraycopy(bytes, 0, results, 0, length);
        return results;
    }

    @Override
    protected String decodeString(byte[] bytes) {
        return FixedLengthString.decodeUtf16Bytes(bytes);
    }

    @Override
    public StyleItem getOrCreateStyle() {
        return null;
    }

    @Override
    int calculateReadLength(BlockReader reader) {
        return this.bytesLength;
    }

    @Override
    protected void onStringChanged(String old, String text) {
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        return CompareUtil.compare(this.get(), stringItem.get());
    }

    @Override
    public String toString() {
        return "FIXED-" + this.bytesLength + " {" + this.get() + "}";
    }

    private static String decodeUtf16Bytes(byte[] bytes) {
        if (FixedLengthString.isNullBytes(bytes)) {
            return null;
        }
        int length = FixedLengthString.getEndNullPosition(bytes);
        return new String(bytes, 0, length, StandardCharsets.UTF_16LE);
    }

    private static int getEndNullPosition(byte[] bytes) {
        int length = bytes.length;
        int result = 0;
        boolean found = false;
        for (int i = 1; i < length; ++i) {
            byte b0 = bytes[i - 1];
            byte b1 = bytes[i];
            if (b0 == 0 && b1 == 0) {
                if (!found) {
                    result = i;
                    found = true;
                    continue;
                }
                if (result >= i - 1) continue;
                return result;
            }
            found = false;
        }
        if (!found) {
            return length;
        }
        return result;
    }
}

