/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BlockItem
extends Block {
    private byte[] mBytes;
    private static final byte[] EMPTY = new byte[0];

    public BlockItem(int bytesLength) {
        this.mBytes = bytesLength == 0 ? EMPTY : new byte[bytesLength];
    }

    protected void onBytesChanged() {
    }

    protected byte[] getBytesInternal() {
        return this.mBytes;
    }

    void setBytesInternal(byte[] bytes) {
        this.setBytesInternal(bytes, true);
    }

    void setBytesInternal(byte[] bytes, boolean notify) {
        if (bytes == null || bytes.length == 0) {
            bytes = EMPTY;
        }
        if (bytes == this.mBytes) {
            return;
        }
        this.mBytes = bytes;
        if (notify) {
            this.onBytesChanged();
        }
    }

    final void setBytesLength(int length) {
        this.setBytesLength(length, true);
    }

    protected final void setBytesLength(int length, boolean notify) {
        if (length < 0) {
            length = 0;
        }
        if (length == 0) {
            this.mBytes = EMPTY;
            if (notify) {
                this.onBytesChanged();
            }
            return;
        }
        int old = this.mBytes.length;
        if (length == old) {
            return;
        }
        byte[] bytes = new byte[length];
        if (length < old) {
            old = length;
        }
        System.arraycopy(this.mBytes, 0, bytes, 0, old);
        this.mBytes = bytes;
        if (notify) {
            this.onBytesChanged();
        }
    }

    int getBytesLength() {
        return this.mBytes.length;
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.getBytesInternal().length;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return this.getBytesInternal();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        counter.setCurrent(this);
        counter.addCount(this.countBytes());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        byte[] bytes = this.getBytesInternal();
        int length = bytes.length;
        if (length == 0) {
            return;
        }
        reader.readFully(bytes);
        this.onBytesChanged();
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        byte[] bytes = this.getBytesInternal();
        int length = bytes.length;
        if (length == 0) {
            return 0;
        }
        stream.write(bytes, 0, length);
        return length;
    }

    public int readBytes(InputStream inputStream) throws IOException {
        byte[] bytes = this.getBytesInternal();
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        int length = bytes.length;
        int offset = 0;
        int read = length;
        while (length > 0 && read > 0) {
            read = inputStream.read(bytes, offset, length);
            length -= read;
            offset += read;
        }
        this.onBytesChanged();
        super.notifyBlockLoad();
        return offset;
    }

    public void setBytes(BlockItem blockItem) {
        if (blockItem != this) {
            byte[] coming = blockItem.getBytesInternal();
            this.setBytesInternal((byte[])coming.clone());
        }
    }
}

