/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.IntegerReference;

public class XmlIDMapHeader
extends HeaderBlock {
    private final IntegerReference idsCount = new CountReference(this);

    public XmlIDMapHeader() {
        super(ChunkType.XML_RESOURCE_MAP);
    }

    public IntegerReference getIdsCount() {
        return this.idsCount;
    }

    static class CountReference
    implements IntegerReference {
        private final XmlIDMapHeader header;

        CountReference(XmlIDMapHeader header) {
            this.header = header;
        }

        @Override
        public int get() {
            return (this.header.getChunkSize() - this.header.getHeaderSize()) / 4;
        }

        @Override
        public void set(int value) {
            this.header.setChunkSize(value * 4 + this.header.getHeaderSize());
        }

        public String toString() {
            return Integer.toString(this.get());
        }
    }
}

