/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class TypeHeader
extends HeaderBlock {
    private final ByteItem id = new ByteItem();
    private final ByteItem flags = new ByteItem();
    private final IntegerItem count;
    private final IntegerItem entriesStart;
    private final ResConfig config;
    private OffsetTypeChangedListener offsetTypeChangedListener;
    public static final int OFFSET_32 = ObjectsUtil.of(0);
    public static final int OFFSET_SPARSE = ObjectsUtil.of(1);
    public static final int OFFSET_16 = ObjectsUtil.of(2);

    public TypeHeader() {
        super(ChunkType.TYPE.ID);
        ShortItem reserved = new ShortItem();
        this.count = new IntegerItem();
        this.entriesStart = new IntegerItem();
        this.config = new ResConfig();
        this.addChild(this.id);
        this.addChild(this.flags);
        this.addChild(reserved);
        this.addChild(this.count);
        this.addChild(this.entriesStart);
        this.addChild(this.config);
    }

    public TypeHeader(boolean sparse, boolean offset16) {
        this();
        this.setSparse(sparse);
        this.setOffset16(offset16);
    }

    public boolean isSparse() {
        return (this.getFlags().get() & 3) == 1;
    }

    public void setSparse(boolean sparse) {
        if (sparse != this.isSparse()) {
            this.setOffsetType(sparse ? OFFSET_SPARSE : OFFSET_32);
        }
    }

    public boolean isOffset16() {
        return (this.getFlags().get() & 3) == 2;
    }

    public void setOffset16(boolean offset16) {
        if (offset16 != this.isOffset16()) {
            this.setOffsetType(offset16 ? OFFSET_16 : OFFSET_32);
        }
    }

    public int getOffsetType() {
        return this.getFlags().get() & 3;
    }

    public void setOffsetType(int type) {
        if (type != this.getOffsetType()) {
            if (type != OFFSET_32 && type != OFFSET_16 && type != OFFSET_SPARSE) {
                throw new IllegalArgumentException("Invalid offset type: " + type);
            }
            this.getFlags().set(this.getFlags().get() & 0xFC | type);
            this.notifyOffsetTypeChanged();
        }
    }

    public void setOffsetType(boolean sparse, boolean offset16) {
        int type = sparse ? OFFSET_SPARSE : (offset16 ? OFFSET_16 : OFFSET_32);
        this.setOffsetType(type);
    }

    @Override
    public int getMinimumSize() {
        return 36;
    }

    public ByteItem getId() {
        return this.id;
    }

    public ByteItem getFlags() {
        return this.flags;
    }

    public IntegerReference getCountItem() {
        return this.count;
    }

    public IntegerReference getEntriesStart() {
        return this.entriesStart;
    }

    public ResConfig getConfig() {
        return this.config;
    }

    private void notifyOffsetTypeChanged() {
        OffsetTypeChangedListener listener = this.offsetTypeChangedListener;
        if (listener != null) {
            listener.onOffsetTypeChanged(this.getOffsetType());
        }
    }

    public void setOffsetTypeChangedListener(OffsetTypeChangedListener listener) {
        this.offsetTypeChangedListener = listener;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.notifyOffsetTypeChanged();
    }

    @Override
    public String toString() {
        if (this.getChunkType() != ChunkType.TYPE) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + " {id=" + this.getId().toHex() + ", flags=" + this.getFlags().toHex() + ", count=" + this.getCountItem() + ", entriesStart=" + this.getEntriesStart() + ", config=" + this.getConfig() + '}';
    }

    public static TypeHeader read(BlockReader reader) throws IOException {
        TypeHeader typeHeader = new TypeHeader(false, false);
        if (reader.available() < typeHeader.getMinimumSize()) {
            throw new IOException("Too few bytes to read type header, available = " + reader.available());
        }
        int pos = reader.getPosition();
        typeHeader.readBytes(reader);
        reader.seek(pos);
        return typeHeader;
    }

    public static interface OffsetTypeChangedListener {
        public void onOffsetTypeChanged(int var1);
    }
}

