/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.item.IntegerItem;

public class PackageHeader
extends HeaderBlock {
    private final IntegerItem packageId = new IntegerItem();
    private final FixedLengthString packageName = new FixedLengthString(256);
    private final IntegerItem typeStringPoolOffset = new IntegerItem();
    private final IntegerItem typeStringPoolCount = new IntegerItem();
    private final IntegerItem specStringPoolOffset = new IntegerItem();
    private final IntegerItem specStringPoolCount = new IntegerItem();
    private final SingleBlockContainer<IntegerItem> typeIdOffsetContainer = new SingleBlockContainer();
    private final IntegerItem typeIdOffset = new IntegerItem();

    public PackageHeader() {
        super(ChunkType.PACKAGE.ID);
        this.typeIdOffsetContainer.setItem(this.typeIdOffset);
        this.addChild(this.packageId);
        this.addChild(this.packageName);
        this.addChild(this.typeStringPoolOffset);
        this.addChild(this.typeStringPoolCount);
        this.addChild(this.specStringPoolOffset);
        this.addChild(this.specStringPoolCount);
        this.addChild(this.typeIdOffsetContainer);
    }

    public IntegerItem getPackageId() {
        return this.packageId;
    }

    public FixedLengthString getPackageName() {
        return this.packageName;
    }

    public IntegerItem getTypeStringPoolOffset() {
        return this.typeStringPoolOffset;
    }

    public IntegerItem getTypeStringPoolCount() {
        return this.typeStringPoolCount;
    }

    public IntegerItem getSpecStringPoolOffset() {
        return this.specStringPoolOffset;
    }

    public IntegerItem getSpecStringPoolCount() {
        return this.specStringPoolCount;
    }

    public IntegerItem getTypeIdOffsetItem() {
        return this.typeIdOffset;
    }

    public void setTypeIdOffset(int offset) {
        this.typeIdOffset.set(offset);
        this.typeIdOffsetContainer.setItem(this.typeIdOffset);
    }

    public int getTypeIdOffset() {
        if (this.typeIdOffset.getParent() == null) {
            this.typeIdOffset.set(0);
        }
        return this.typeIdOffset.get();
    }

    @Override
    void onHeaderSizeLoaded(int size) {
        super.onHeaderSizeLoaded(size);
        if (size < 288) {
            this.typeIdOffset.set(0);
            this.typeIdOffsetContainer.setItem(null);
        }
    }
}

