/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.common.FileChannelInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InfoHeader
extends HeaderBlock {
    public static final int INFO_MIN_SIZE = 8;

    public InfoHeader(short type) {
        super(type);
    }

    public InfoHeader() {
        this(0);
    }

    @Override
    public int getMinimumSize() {
        return 8;
    }

    @Override
    void initExtraBytes(ByteArray extraBytes, int difference) {
    }

    @Override
    public int countBytes() {
        return 8;
    }

    public static InfoHeader readHeaderBlock(File file) throws IOException {
        return InfoHeader.readHeaderBlock(FileChannelInputStream.read(file, 8));
    }

    public static InfoHeader readHeaderBlock(InputStream inputStream) throws IOException {
        InfoHeader infoHeader = new InfoHeader();
        infoHeader.readBytes(inputStream);
        return infoHeader;
    }

    public static InfoHeader readHeaderBlock(BlockReader blockReader) throws IOException {
        InfoHeader infoHeader = new InfoHeader();
        infoHeader.readBytes(blockReader);
        return infoHeader;
    }

    public static InfoHeader readHeaderBlock(byte[] bytes) throws IOException {
        BlockReader reader = new BlockReader(bytes);
        InfoHeader infoHeader = new InfoHeader();
        infoHeader.readBytes(reader);
        return infoHeader;
    }

    public static InfoHeader read(BlockReader reader) throws IOException {
        InfoHeader infoHeader = new InfoHeader();
        if (reader.available() < infoHeader.getMinimumSize()) {
            return null;
        }
        int pos = reader.getPosition();
        infoHeader.readBytes(reader);
        reader.seek(pos);
        return infoHeader;
    }
}

