/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;

public class ExpandableBlockContainer
extends BlockContainer<Block> {
    private Block[] mChildes;
    private int mCursor;

    public ExpandableBlockContainer(int initialSize) {
        this.mChildes = new Block[initialSize];
    }

    public final void addChild(Block block) {
        if (block == null) {
            return;
        }
        int index = this.mCursor++;
        this.ensureCount(index + 1);
        this.mChildes[index] = block;
        block.setIndex(index);
        block.setParent(this);
    }

    private void ensureCount(int count) {
        if (count <= this.getChildesCount()) {
            return;
        }
        Block[] old = this.mChildes;
        this.mChildes = new Block[count];
        for (int i = 0; i < old.length; ++i) {
            this.mChildes[i] = old[i];
        }
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public final int getChildesCount() {
        return this.mChildes.length;
    }

    public final Block[] getChildes() {
        return this.mChildes;
    }
}

