/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.xml.XMLNode;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class UnknownResXmlNode
extends ResXmlNode {
    public UnknownResXmlNode(Chunk<?> chunk) {
        super(chunk);
    }

    public UnknownResXmlNode() {
        this(new UnknownChunk());
    }

    @Override
    public Chunk<?> getChunk() {
        return (Chunk)this.getBaseBlock();
    }

    @Override
    void onPreRemove() {
    }

    @Override
    void linkStringReferences() {
    }

    @Override
    Iterator<ResXmlEvent> getParserEvents() {
        return EmptyIterator.of();
    }

    @Override
    int autoSetLineNumber(int start) {
        return 0;
    }

    @Override
    String nodeTypeName() {
        return JSON_node_type_unknown;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    public String getHexBytes() {
        return HexUtil.toHexString(this.getBytes());
    }

    public void setHexBytes(String hexBytes) throws NumberFormatException {
        byte[] bytes = HexUtil.fromHexSting(hexBytes);
        try {
            this.readBytes(new BlockReader(bytes));
        }
        catch (IOException exception) {
            throw new NumberFormatException("Invalid chunk hex bytes:" + exception.getMessage());
        }
    }

    public int getChunkType() {
        return ((HeaderBlock)((Chunk)this.getChunk()).getHeaderBlock()).getType() & 0xFFFF;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_node_type, this.nodeTypeName());
        jsonObject.put(JSON_type, this.getChunkType());
        jsonObject.put(JSON_value, this.getHexBytes());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) throws NumberFormatException {
        if (!this.nodeTypeName().equals(json.optString(JSON_node_type, null))) {
            throw new JSONException("Expecting: " + this.nodeTypeName() + ", but found: " + json.optString(JSON_node_type, null));
        }
        if (json.has(JSON_value)) {
            this.setHexBytes(json.getString(JSON_value));
        }
    }

    @Override
    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
    }

    @Override
    public XMLNode toXml(boolean decode) {
        return null;
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlNode xmlNode) {
    }

    @Override
    public void merge(ResXmlNode xmlNode) {
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public void setLineNumber(int lineNumber) {
    }
}

