/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;

public class ResXmlTextChunk
extends BaseXmlChunk {
    private final IntegerItem mReserved = new IntegerItem();

    public ResXmlTextChunk() {
        super(ChunkType.XML_CDATA, 1);
        this.addChild(this.mReserved);
        this.setStringReference(0);
    }

    public String getText() {
        ResXmlString xmlString = this.getResXmlString(this.getTextReference());
        if (xmlString != null) {
            return xmlString.getXml();
        }
        return null;
    }

    public int getTextReference() {
        return this.getNamespaceReference();
    }

    public void setTextReference(int ref) {
        this.setNamespaceReference(ref);
    }

    public void setText(String text) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        ResXmlString resXmlString = stringPool.getOrCreate(text);
        this.setTextReference(resXmlString.getIndex());
    }

    @Override
    public void setComment(String comment) {
        super.setComment(comment);
        if (comment != null && this.getText() == null) {
            this.setText("");
        }
    }

    @Override
    public boolean isNull() {
        return this.getComment() == null && this.getText() == null || super.isNull();
    }

    @Override
    protected void onPreRefresh() {
        if (this.getComment() != null && this.getText() == null) {
            this.setText("");
        }
        super.onPreRefresh();
    }

    @Override
    public String toString() {
        String text = this.getText();
        if (text != null) {
            return text;
        }
        return super.toString();
    }
}

