/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNamespaceChunk;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.model.ResourceLibrary;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.StringsUtil;
import java.util.HashSet;
import java.util.Set;

public class ResXmlStartNamespace
extends ResXmlNamespaceChunk
implements JSONConvert<JSONObject> {
    private final Set<ResXmlAttribute> mReferencedAttributes;
    private final Set<ResXmlStartElement> mReferencedElements;
    private final ResXmlEndNamespace mEndNamespace;

    public ResXmlStartNamespace(ResXmlEndNamespace endNamespace) {
        super(ChunkType.XML_START_NAMESPACE);
        this.mEndNamespace = endNamespace;
        this.mReferencedAttributes = new HashSet<ResXmlAttribute>();
        this.mReferencedElements = new HashSet<ResXmlStartElement>();
    }

    public ResXmlElement element() {
        return this.getParentInstance(ResXmlElement.class);
    }

    void ensureUniqueUri() {
        ResXmlString prefixXmlString;
        ResXmlString xmlString = this.getResXmlString(this.getUriReference());
        if (xmlString != null && (prefixXmlString = xmlString.getNamespacePrefix()) != null && prefixXmlString.getIndex() == this.getPrefixReference()) {
            return;
        }
        this.set(this.getUri(), this.getPrefix());
    }

    public void set(String uri, String prefix) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool != null) {
            int prefixReference;
            int uriReference;
            ResXmlString resXmlString = stringPool.getOrCreateNamespaceString(uri, prefix);
            if (resXmlString != null) {
                uriReference = resXmlString.getIndex();
                prefixReference = resXmlString.getNamespacePrefix().getIndex();
            } else {
                uriReference = NULL_REFERENCE;
                prefixReference = NULL_REFERENCE;
            }
            this.setUriReference(uriReference);
            this.setPrefixReference(prefixReference);
        }
    }

    @Override
    void onUriReferenceChanged(int uriReference) {
        for (ResXmlAttribute attribute : this.mReferencedAttributes) {
            attribute.setUriReference(uriReference);
        }
        for (ResXmlStartElement element : this.mReferencedElements) {
            element.setNamespaceReference(uriReference);
        }
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.linkStringReferences();
    }

    public ResXmlEndNamespace getEnd() {
        return this.mEndNamespace;
    }

    @Override
    void setStringReference(int value) {
        super.setStringReference(value);
        this.getEnd().setStringReference(value);
    }

    @Override
    void setNamespaceReference(int value) {
        super.setNamespaceReference(value);
        this.getEnd().setNamespaceReference(value);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        if (lineNumber != this.getLineNumber()) {
            super.setLineNumber(lineNumber);
            this.getEnd().setLineNumber(lineNumber);
        }
    }

    @Override
    void onPreRemove() {
        this.mReferencedAttributes.clear();
        this.mReferencedElements.clear();
        super.onPreRemove();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        ResXmlEndNamespace end = this.getEnd();
        end.setNamespaceReference(this.getNamespaceReference());
        end.setStringReference(this.getStringReference());
    }

    @Override
    public boolean isUnused() {
        return this.getReferencedCount() == 0;
    }

    public boolean isUndefined() {
        if (this.isRemoved()) {
            return true;
        }
        return this.getUriReference() == -1 && this.getPrefixReference() == -1;
    }

    public int getReferencedCount() {
        if (this.isRemoved()) {
            return 0;
        }
        return this.mReferencedAttributes.size() + this.mReferencedElements.size();
    }

    public boolean isBetterThan(ResXmlStartNamespace namespace) {
        if (namespace == null) {
            return true;
        }
        return this.getReferencedCount() > namespace.getReferencedCount();
    }

    void addAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.add(attribute);
        }
    }

    void removeAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.remove(attribute);
        }
    }

    void addElementReference(ResXmlStartElement element) {
        if (element != null) {
            this.mReferencedElements.add(element);
        }
    }

    void removeElementReference(ResXmlStartElement element) {
        if (element != null) {
            this.mReferencedElements.remove(element);
        }
    }

    void fixEmpty() {
        if (StringsUtil.isBlank(this.getPrefix())) {
            this.setPrefix("ns" + this.getIndex());
        }
        if (StringsUtil.isBlank(this.getUri())) {
            this.setUri(ResourceLibrary.URI_RES_AUTO);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ResXmlNode.JSON_uri, this.getUri());
        jsonObject.put(ResXmlNode.JSON_prefix, this.getPrefix());
        jsonObject.put(ResXmlNode.JSON_line, this.getLineNumber());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.set(json.getString(ResXmlElement.JSON_uri), json.getString(ResXmlElement.JSON_prefix));
        this.setLineNumber(json.optInt(ResXmlElement.JSON_line));
    }

    public void merge(ResXmlStartNamespace namespace) {
        if (namespace == this) {
            return;
        }
        this.set(namespace.getUri(), namespace.getPrefix());
        this.setLineNumber(namespace.getLineNumber());
        this.setComment(namespace.getComment());
        ResXmlEndNamespace end = this.getEnd();
        ResXmlEndNamespace coming = namespace.getEnd();
        end.setLineNumber(coming.getLineNumber());
        end.setComment(coming.getComment());
    }
}

