/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlAttributeArray;
import com.reandroid.arsc.chunk.xml.ResXmlAttributePosition;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.XmlNodeHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class ResXmlStartElement
extends BaseXmlChunk {
    private final ShortItem mAttributeStart;
    private final IntegerReference mAttributeUnitSize;
    private final ShortItem mAttributeCount;
    private final ResXmlAttributePosition mIdAttributePosition;
    private final ResXmlAttributePosition mClassAttributePosition;
    private final ResXmlAttributePosition mStyleAttributePosition;
    private final SingleBlockContainer<Block> firstPlaceHolder2;
    private final ResXmlAttributeArray mAttributeArray;
    private final ResXmlEndElement mResXmlEndElement;
    private final IntegerReference attributesOffset;
    private final UnknownBytes unknownBytes;
    private static final short ATTRIBUTES_UNIT_SIZE = 20;
    private static final short ATTRIBUTES_DEFAULT_START = 20;

    public ResXmlStartElement(ResXmlEndElement endElement) {
        super(ChunkType.XML_START_ELEMENT, null, 9);
        IntegerReference unitSize;
        ShortItem _attributeCount;
        this.mResXmlEndElement = endElement;
        this.mAttributeStart = new ShortItem(20);
        final ShortItem _unitSizeReferenceBlock = new ShortItem(20);
        this.mAttributeCount = _attributeCount = new ShortItem();
        this.mIdAttributePosition = new ResXmlAttributePosition(ResXmlAttributePosition.TYPE_ID);
        this.mClassAttributePosition = new ResXmlAttributePosition(ResXmlAttributePosition.TYPE_CLASS);
        this.mStyleAttributePosition = new ResXmlAttributePosition(ResXmlAttributePosition.TYPE_STYLE);
        this.firstPlaceHolder2 = new SingleBlockContainer();
        this.attributesOffset = new IntegerReference(){
            private final ResXmlStartElement _startElement;
            {
                this._startElement = ResXmlStartElement.this;
            }

            @Override
            public int get() {
                return ((XmlNodeHeader)this._startElement.getHeaderBlock()).getHeaderSize() + this._startElement.getAttributeStart().get();
            }

            @Override
            public void set(int value) {
                this._startElement.getAttributeStart().set(value - ((XmlNodeHeader)this._startElement.getHeaderBlock()).countBytes());
            }

            public String toString() {
                return Integer.toString(this.get());
            }
        };
        this.unknownBytes = new UnknownBytes(this);
        this.mAttributeUnitSize = unitSize = new IntegerReference(){
            private final ResXmlStartElement _startElement;
            private final IntegerReference _reference;
            {
                this._startElement = ResXmlStartElement.this;
                this._reference = _unitSizeReferenceBlock;
            }

            @Override
            public int get() {
                int i = this._reference.get();
                if (i < 20 && this._startElement.getAttributeCount().get() != 0) {
                    i = 20;
                    this._reference.set(i);
                }
                return i;
            }

            @Override
            public void set(int value) {
                this._reference.set(value);
                ResXmlAttributeArray attributeArray = this._startElement.getResXmlAttributeArray();
                int count = attributeArray.size();
                for (int i = 0; i < count; ++i) {
                    ((ResXmlAttribute)attributeArray.get(i)).setAttributesUnitSize(value);
                }
            }

            public String toString() {
                return Integer.toString(this._reference.get());
            }
        };
        this.mAttributeArray = new ResXmlAttributeArray(unitSize, (IntegerReference)_attributeCount);
        this.addChild(this.mAttributeStart);
        this.addChild(_unitSizeReferenceBlock);
        this.addChild(_attributeCount);
        this.addChild(this.mIdAttributePosition);
        this.addChild(this.mClassAttributePosition);
        this.addChild(this.mStyleAttributePosition);
        this.addChild(this.firstPlaceHolder2);
        this.addChild(this.unknownBytes);
        this.addChild(this.mAttributeArray);
    }

    IntegerReference getAttributeStart() {
        return this.mAttributeStart;
    }

    IntegerReference getAttributeCount() {
        return this.mAttributeCount;
    }

    IntegerReference getAttributeUnitSize() {
        return this.mAttributeUnitSize;
    }

    ResXmlAttributePosition getIdAttributePosition() {
        return this.mIdAttributePosition;
    }

    ResXmlAttributePosition getClassAttributePosition() {
        return this.mClassAttributePosition;
    }

    ResXmlAttributePosition getStyleAttributePosition() {
        return this.mStyleAttributePosition;
    }

    public IntegerReference getAttributesOffset() {
        return this.attributesOffset;
    }

    public UnknownBytes getUnknownBytes() {
        return this.unknownBytes;
    }

    @Override
    void linkStringReferences() {
        super.linkStringReferences();
        this.getResXmlEndElement().linkStringReferences();
        this.linkNamespace();
        this.getIdAttributePosition().linkAttribute();
        this.getClassAttributePosition().linkAttribute();
        this.getStyleAttributePosition().linkAttribute();
    }

    @Override
    void onPreRemove() {
        super.onPreRemove();
        this.unlinkNamespace();
        this.getResXmlAttributeArray().clear();
        this.getResXmlEndElement().onPreRemove();
        this.getIdAttributePosition().clear();
        this.getClassAttributePosition().clear();
        this.getStyleAttributePosition().clear();
    }

    void unlinkNamespace() {
        ResXmlStartNamespace namespace = this.getResXmlStartNamespace();
        if (namespace != null) {
            namespace.removeElementReference(this);
        }
    }

    void linkNamespace() {
        ResXmlStartNamespace namespace = this.getResXmlStartNamespace();
        if (namespace != null) {
            namespace.addElementReference(this);
        }
    }

    public String getName(boolean includePrefix) {
        String prefix;
        String name = super.getName();
        if (includePrefix && (prefix = this.getPrefix()) != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    public void setName(String name) {
        if (name == null) {
            this.setStringReference(-1);
        } else {
            this.setString(name);
        }
    }

    public ResXmlAttributeArray getResXmlAttributeArray() {
        return this.mAttributeArray;
    }

    @Override
    public String getUri() {
        ResXmlStartNamespace startNamespace = this.getResXmlStartNamespace();
        if (startNamespace != null) {
            return startNamespace.getUri();
        }
        return null;
    }

    public String getPrefix() {
        ResXmlStartNamespace startNamespace = this.getResXmlStartNamespace();
        if (startNamespace != null) {
            return startNamespace.getPrefix();
        }
        return null;
    }

    public void setTagNamespace(String uri, String prefix) {
        this.unlinkNamespace();
        if (uri == null || prefix == null) {
            this.setNamespaceReference(-1);
            return;
        }
        ResXmlElement parentElement = this.getNodeElement();
        if (parentElement == null) {
            return;
        }
        ResXmlNamespace ns = parentElement.getOrCreateNamespace(uri, prefix);
        this.setNamespaceReference(ns.getUriReference());
        this.linkNamespace();
    }

    @Override
    void setNamespaceReference(int value) {
        super.setNamespaceReference(value);
        this.getResXmlEndElement().setNamespaceReference(value);
    }

    @Override
    void setStringReference(int value) {
        super.setStringReference(value);
        this.getResXmlEndElement().setStringReference(value);
    }

    ResXmlStartNamespace getResXmlStartNamespace() {
        ResXmlElement parentElement;
        int uriRef = this.getNamespaceReference();
        if (uriRef != NULL_REFERENCE && (parentElement = this.getNodeElement()) != null) {
            return (ResXmlStartNamespace)parentElement.getNamespaceForUriReference(uriRef);
        }
        return null;
    }

    public ResXmlEndElement getResXmlEndElement() {
        return this.mResXmlEndElement;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.getResXmlAttributeArray().sort();
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        this.getResXmlEndElement().setLineNumber(lineNumber);
    }

    @Override
    public SingleBlockContainer<Block> getFirstPlaceHolder() {
        return this.firstPlaceHolder2;
    }

    @Override
    protected void onChunkRefreshed() {
        super.onChunkRefreshed();
        this.updateAttributesOffset();
        this.refreshAttributePositions();
    }

    void updateAttributesOffset() {
        if (this.getAttributeCount().get() != 0) {
            this.getAttributesOffset().set(this.countUpTo(this.getResXmlAttributeArray()));
        }
    }

    void refreshAttributePositions() {
        this.getIdAttributePosition().refresh();
        this.getClassAttributePosition().refresh();
        this.getStyleAttributePosition().refresh();
    }

    void fixClassStyleAttributeNames() {
        this.getClassAttributePosition().fixName();
        this.getStyleAttributePosition().fixName();
    }

    @Override
    public String toString() {
        String name = this.getName(true);
        if (name == null) {
            return super.toString();
        }
        return name + " " + StringsUtil.join(this.getResXmlAttributeArray().iterator(), (Object)Character.valueOf(' '));
    }

    public static class UnknownBytes
    extends BlockItem {
        private final ResXmlStartElement startElement;

        UnknownBytes(ResXmlStartElement startElement) {
            super(0);
            this.startElement = startElement;
        }

        public int size() {
            return this.countBytes();
        }

        public void setSize(int size) {
            this.setBytesLength(size, false);
            this.startElement.updateAttributesOffset();
        }

        @Override
        public byte[] getBytes() {
            return super.getBytesInternal();
        }

        public void setBytes(byte[] bytes) {
            int length = bytes.length;
            this.setSize(length);
            if (length != 0) {
                byte[] internal = this.getBytes();
                System.arraycopy(bytes, 0, internal, 0, length);
            }
        }

        public void clear() {
            this.setSize(0);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
            ResXmlStartElement startElement = this.startElement;
            int size = startElement.getAttributeCount().get() == 0 ? 0 : startElement.getAttributesOffset().get() - reader.getPosition();
            this.setBytesLength(size, false);
            super.onReadBytes(reader);
        }

        public String toString() {
            return "size = " + this.size();
        }
    }
}

