/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.app.AndroidManifest;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class AndroidManifestBlock
extends ResXmlDocument
implements AndroidManifest {
    private int mGuessedPackageId;
    public static final Predicate<ResXmlElement> PREDICATE_FUSED_MODULES = element -> element.equalsName(TAG_meta_data) && VALUE_com_android_dynamic_apk_fused_modules.equals(AndroidManifestBlock.getAndroidNameValue(element));

    public AndroidManifestBlock() {
        super.getStringPool().setUtf8(false);
    }

    public ApkFile.ApkType guessApkType() {
        if (this.isSplit()) {
            return ApkFile.ApkType.SPLIT;
        }
        Boolean core = this.isCoreApp();
        if (core != null && core.booleanValue()) {
            return ApkFile.ApkType.CORE;
        }
        if (this.getMainActivity() != null) {
            return ApkFile.ApkType.BASE;
        }
        return null;
    }

    public Boolean isCoreApp() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_coreApp);
        if (attribute == null) {
            return null;
        }
        if (attribute.getValueType() != ValueType.BOOLEAN) {
            return null;
        }
        return attribute.getValueAsBoolean();
    }

    public boolean isSplit() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return false;
        }
        return manifest.searchAttributeByName(NAME_split) != null;
    }

    public String getSplit() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_split);
        if (attribute != null) {
            return attribute.getValueAsString();
        }
        return null;
    }

    public void setSplit(String split, boolean forceCreate) {
        ResXmlAttribute attribute;
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return;
        }
        if (forceCreate) {
            attribute = manifest.getOrCreateAttribute(NAME_split, 0);
        } else {
            attribute = manifest.searchAttributeByName(NAME_split);
            if (attribute == null) {
                return;
            }
        }
        attribute.setValueAsString(split);
    }

    public boolean isFusingInclude() {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement != null) {
            Iterator modules = manifestElement.getElements("module");
            while (modules.hasNext()) {
                Iterator iterator = ((ResXmlElement)modules.next()).getElements("fusing");
                while (iterator.hasNext()) {
                    ResXmlAttribute attribute = ((ResXmlElement)iterator.next()).searchAttributeByName("include");
                    if (attribute == null || attribute.getValueType() != ValueType.BOOLEAN) continue;
                    return attribute.getValueAsBoolean();
                }
            }
        }
        return false;
    }

    public String[] getFusedModuleNames() {
        ResXmlAttribute attribute;
        ResXmlElement metaData;
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement != null && (metaData = (ResXmlElement)CollectionUtil.getFirst(applicationElement.getElements(PREDICATE_FUSED_MODULES))) != null && (attribute = metaData.searchAttributeByResourceId(ID_value)) != null && attribute.getValueType() == ValueType.STRING) {
            return StringsUtil.split(attribute.getValueAsString(), ',');
        }
        return null;
    }

    public void addFusedModuleNames(String ... names) {
        if (names == null || names.length == 0) {
            return;
        }
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlElement metaData = (ResXmlElement)CollectionUtil.getFirst(applicationElement.getElements(PREDICATE_FUSED_MODULES));
        if (metaData == null) {
            metaData = applicationElement.newElement(TAG_meta_data);
            metaData.getOrCreateAndroidAttribute(NAME_name, ID_name).setValueAsString(VALUE_com_android_dynamic_apk_fused_modules);
        }
        ResXmlAttribute attribute = metaData.getOrCreateAndroidAttribute(NAME_value, ID_value);
        ArrayCollection<String> nameList = new ArrayCollection<String>();
        String value = attribute.getValueAsString();
        if (value != null) {
            nameList.addAll(StringsUtil.split(value, ','));
        }
        for (String name : names) {
            if (StringsUtil.isEmpty(name) || nameList.contains(name)) continue;
            nameList.add(name);
        }
        attribute.setValueAsString(StringsUtil.join(nameList, (Object)Character.valueOf(',')));
    }

    public boolean clearFusedModuleNames() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement != null) {
            return applicationElement.removeElementsIf(PREDICATE_FUSED_MODULES);
        }
        return false;
    }

    public int guessCurrentPackageId() {
        if (this.mGuessedPackageId == 0) {
            this.mGuessedPackageId = this.getIconResourceId() >> 24 & 0xFF;
        }
        return this.mGuessedPackageId;
    }

    @Override
    PackageBlock selectPackageBlock(TableBlock tableBlock) {
        ResourceEntry resourceEntry = tableBlock.getResource(this.getIconResourceId());
        if (resourceEntry == null) {
            return super.selectPackageBlock(tableBlock);
        }
        PackageBlock packageBlock = resourceEntry.getPackageBlock();
        if (packageBlock.getTableBlock() != tableBlock) {
            return super.selectPackageBlock(tableBlock);
        }
        return packageBlock;
    }

    public int getIconResourceId() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return 0;
        }
        ResXmlAttribute attribute = applicationElement.searchAttributeByResourceId(ID_icon);
        if (attribute == null || attribute.getValueType() != ValueType.REFERENCE) {
            return 0;
        }
        return attribute.getData();
    }

    public void setIconResourceId(int resourceId) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute iconAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_icon, ID_icon);
        iconAttribute.setTypeAndData(ValueType.REFERENCE, resourceId);
    }

    public int getRoundIconResourceId() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return 0;
        }
        ResXmlAttribute attribute = applicationElement.searchAttributeByResourceId(ID_roundIcon);
        if (attribute == null || attribute.getValueType() != ValueType.REFERENCE) {
            return 0;
        }
        return attribute.getData();
    }

    public void setRoundIconResourceId(int resourceId) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute iconAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_icon, ID_roundIcon);
        iconAttribute.setTypeAndData(ValueType.REFERENCE, resourceId);
    }

    public Integer getApplicationLabelReference() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return null;
        }
        ResXmlAttribute labelAttribute = applicationElement.searchAttributeByResourceId(ID_label);
        if (labelAttribute == null || labelAttribute.getValueType() != ValueType.REFERENCE) {
            return null;
        }
        return labelAttribute.getData();
    }

    public void setApplicationLabel(int resourceId) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute labelAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_label, ID_label);
        labelAttribute.setTypeAndData(ValueType.REFERENCE, resourceId);
    }

    public String getApplicationLabelString() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return null;
        }
        ResXmlAttribute labelAttribute = applicationElement.searchAttributeByResourceId(ID_label);
        if (labelAttribute == null || labelAttribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return labelAttribute.getValueAsString();
    }

    public void setApplicationLabel(String label) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute labelAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_label, ID_label);
        labelAttribute.setValueAsString(label);
    }

    public Boolean isExtractNativeLibs() {
        ResXmlAttribute attribute;
        ResXmlElement application = this.getApplicationElement();
        if (application != null && (attribute = application.searchAttributeByResourceId(ID_extractNativeLibs)) != null && attribute.getValueType() == ValueType.BOOLEAN) {
            return attribute.getValueAsBoolean();
        }
        return null;
    }

    public void setExtractNativeLibs(Boolean value) {
        ResXmlElement application;
        ResXmlElement resXmlElement = application = value == null ? this.getApplicationElement() : this.getOrCreateApplicationElement();
        if (application != null) {
            if (value == null) {
                application.removeAttributesWithId(ID_extractNativeLibs);
            } else {
                ResXmlAttribute attribute = application.getOrCreateAndroidAttribute(NAME_extractNativeLibs, ID_extractNativeLibs);
                attribute.setValueAsBoolean(value);
            }
        }
    }

    public boolean isDebuggable() {
        ResXmlAttribute attribute;
        ResXmlElement application = this.getApplicationElement();
        if (application != null && (attribute = application.searchAttributeByResourceId(ID_debuggable)) != null) {
            return attribute.getValueAsBoolean();
        }
        return false;
    }

    public void setDebuggable(boolean debuggable) {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return;
        }
        ResXmlAttribute attribute = application.searchAttributeByResourceId(ID_debuggable);
        if (debuggable) {
            if (attribute == null) {
                attribute = application.createAndroidAttribute(NAME_debuggable, ID_debuggable);
            }
            attribute.setValueAsBoolean(true);
        } else if (attribute != null) {
            application.removeAttribute(attribute);
        }
    }

    public ResXmlElement getMainActivity() {
        Iterator<ResXmlElement> iterator = this.getActivities(true);
        while (iterator.hasNext()) {
            ResXmlElement activity = iterator.next();
            Iterator actions = activity.getElementsWithChild(new String[]{TAG_intent_filter, TAG_action});
            while (actions.hasNext()) {
                ResXmlElement action = (ResXmlElement)actions.next();
                ResXmlAttribute attribute = action.searchAttributeByResourceId(ID_name);
                if (attribute == null || !VALUE_android_intent_action_MAIN.equals(attribute.getValueAsString())) continue;
                return activity;
            }
        }
        return null;
    }

    public ResXmlElement getOrCreateMainActivity(String name) {
        ResXmlElement activity = this.getMainActivity();
        if (activity == null) {
            ResXmlElement application = this.getOrCreateApplicationElement();
            activity = application.newElementAt(0, TAG_activity);
            ResXmlElement intentFilter = activity.newElement(TAG_intent_filter);
            ResXmlElement action = intentFilter.newElement(TAG_action);
            ResXmlAttribute attribute = action.getOrCreateAndroidAttribute(NAME_name, ID_name);
            attribute.setValueAsString(VALUE_android_intent_action_MAIN);
            ResXmlElement category = intentFilter.newElement(TAG_category);
            attribute = category.getOrCreateAndroidAttribute(NAME_name, ID_name);
            attribute.setValueAsString("android.intent.category.DEFAULT");
            category = intentFilter.newElement(TAG_category);
            attribute = category.getOrCreateAndroidAttribute(NAME_name, ID_name);
            attribute.setValueAsString("android.intent.category.LAUNCHER");
        }
        ResXmlAttribute attribute = activity.getOrCreateAndroidAttribute(NAME_name, ID_name);
        attribute.setValueAsString(name);
        return activity;
    }

    public ResXmlElement getOrCreateActivity(String name, boolean activityAlias) {
        ResXmlElement activity = this.getActivity(name, activityAlias);
        if (activity == null) {
            ResXmlElement application = this.getOrCreateApplicationElement();
            activity = application.newElement(activityAlias ? TAG_activity_alias : TAG_activity);
            ResXmlAttribute attribute = activity.createAndroidAttribute(AndroidManifest.NAME_name, ID_name);
            attribute.setValueAsString(name);
        }
        return activity;
    }

    public ResXmlElement getActivity(String name, boolean activityAlias) {
        name = this.fullClassName(name);
        Iterator<ResXmlElement> iterator = this.getActivities(true);
        while (iterator.hasNext()) {
            ResXmlElement element = iterator.next();
            if (!ObjectsUtil.equals(name, AndroidManifestBlock.getAndroidNameValue(element))) continue;
            return element;
        }
        return null;
    }

    @Deprecated
    public List<ResXmlElement> listActivities() {
        ArrayCollection<ResXmlElement> results = new ArrayCollection<ResXmlElement>();
        results.addAll(this.getActivities(true));
        return results;
    }

    @Deprecated
    public List<ResXmlElement> listActivities(boolean includeActivityAlias) {
        ArrayCollection<ResXmlElement> results = new ArrayCollection<ResXmlElement>();
        results.addAll(this.getActivities(includeActivityAlias));
        return results;
    }

    public Iterator<ResXmlElement> getActivities(boolean includeAlias) {
        Iterator iterator = this.getElementsWithChild(new String[]{TAG_manifest, TAG_application, TAG_activity});
        if (!includeAlias) {
            return iterator;
        }
        return CombiningIterator.two(iterator, this.getElementsWithChild(new String[]{TAG_manifest, TAG_application, TAG_activity_alias}));
    }

    public List<ResXmlElement> listApplicationElementsByTag(String tag) {
        return CollectionUtil.toList(this.getApplicationElementsByTag(tag));
    }

    public Iterator<ResXmlElement> getApplicationElementsByTag(String tag) {
        return this.getElementsWithChild(new String[]{TAG_manifest, TAG_application, tag});
    }

    public List<String> getUsesPermissions() {
        Iterator<String> iterator = ComputeIterator.of(this.getElementsWithChild(new String[]{TAG_manifest, TAG_uses_permission}), AndroidManifestBlock::getAndroidNameValue);
        return CollectionUtil.toList(iterator);
    }

    public ResXmlElement getUsesPermission(String permissionName) {
        Iterator iterator = this.getElementsWithChild(new String[]{TAG_manifest, TAG_uses_permission});
        while (iterator.hasNext()) {
            ResXmlElement element = (ResXmlElement)iterator.next();
            if (!ObjectsUtil.equals(permissionName, AndroidManifestBlock.getAndroidNameValue(element))) continue;
            return element;
        }
        return null;
    }

    public ResXmlElement addUsesPermission(String permissionName) {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        ResXmlElement exist = this.getUsesPermission(permissionName);
        if (exist != null) {
            return exist;
        }
        int i = manifestElement.lastIndexOf(TAG_uses_permission);
        ResXmlElement result = manifestElement.newElement(TAG_uses_permission);
        ResXmlAttribute attr = result.getOrCreateAndroidAttribute(AndroidManifest.NAME_name, ID_name);
        attr.setValueAsString(permissionName);
        manifestElement.moveTo(result, ++i);
        return result;
    }

    @Override
    public String getPackageName() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_PACKAGE);
        if (attribute == null || attribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return attribute.getValueAsString();
    }

    @Override
    public void setPackageName(String packageName) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAttribute(NAME_PACKAGE, 0);
        attribute.setValueAsString(packageName);
    }

    @Override
    public String getApplicationClassName() {
        ResXmlAttribute attribute;
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement != null && (attribute = applicationElement.searchAttributeByResourceId(ID_name)) != null) {
            return this.fullClassName(attribute.getValueAsString());
        }
        return null;
    }

    @Override
    public void setApplicationClassName(String className) {
        ResXmlAttribute attribute = this.getOrCreateApplicationElement().getOrCreateAndroidAttribute(AndroidManifest.NAME_name, ID_name);
        attribute.setValueAsString(className);
    }

    @Override
    public String getMainActivityClassName() {
        ResXmlAttribute attribute;
        ResXmlElement mainActivity = this.getMainActivity();
        if (mainActivity != null && (attribute = mainActivity.searchAttributeByResourceId(ID_name)) != null) {
            return this.fullClassName(attribute.getValueAsString());
        }
        return null;
    }

    @Override
    public void setMainActivityClassName(String className) {
        this.getOrCreateMainActivity(className);
    }

    @Override
    public Integer getVersionCode() {
        return this.getManifestAttributeInt(ID_versionCode);
    }

    @Override
    public void setVersionCode(int version) {
        this.setManifestAttributeInt(NAME_versionCode, ID_versionCode, version);
    }

    @Override
    public String getVersionName() {
        return this.getManifestAttributeString(ID_versionName);
    }

    @Override
    public void setVersionName(String versionName) {
        this.setManifestAttributeString(NAME_versionName, ID_versionName, versionName);
    }

    @Override
    public Integer getPlatformBuildVersionCode() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_platformBuildVersionCode);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    @Override
    public void setPlatformBuildVersionCode(int version) {
        this.setManifestAttributeInt(NAME_platformBuildVersionCode, 0, version);
    }

    @Override
    public Object getPlatformBuildVersionName() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_platformBuildVersionName);
        if (attribute == null) {
            return null;
        }
        if (attribute.getValueType() == ValueType.STRING) {
            return attribute.getValueAsString();
        }
        return attribute.getData();
    }

    @Override
    public void setPlatformBuildVersionName(Object name) {
        Integer versionNumber = null;
        if (name instanceof Integer) {
            versionNumber = (Integer)name;
        } else {
            try {
                versionNumber = Integer.parseInt((String)name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (versionNumber != null) {
            this.setManifestAttributeInt(NAME_platformBuildVersionName, 0, versionNumber);
        } else {
            this.setManifestAttributeString(NAME_platformBuildVersionName, 0, (String)name);
        }
    }

    @Override
    public Integer getMinSdkVersion() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlElement usesSdk = manifest.getElement(TAG_uses_sdk);
        if (usesSdk == null) {
            return null;
        }
        ResXmlAttribute attribute = usesSdk.searchAttributeByResourceId(ID_minSdkVersion);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    @Override
    public void setMinSdkVersion(int version) {
        ResXmlElement manifest = this.getOrCreateManifestElement();
        ResXmlElement usesSdk = manifest.getElement(TAG_uses_sdk);
        if (usesSdk == null) {
            usesSdk = manifest.newElement(TAG_uses_sdk);
        }
        ResXmlAttribute attribute = usesSdk.getOrCreateAndroidAttribute(NAME_minSdkVersion, ID_minSdkVersion);
        attribute.setTypeAndData(ValueType.DEC, version);
    }

    @Override
    public Integer getTargetSdkVersion() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlElement usesSdk = manifest.getElement(TAG_uses_sdk);
        if (usesSdk == null) {
            return null;
        }
        ResXmlAttribute attribute = usesSdk.searchAttributeByResourceId(ID_targetSdkVersion);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    @Override
    public void setTargetSdkVersion(int version) {
        ResXmlElement manifest = this.getOrCreateManifestElement();
        ResXmlElement usesSdk = manifest.getElement(TAG_uses_sdk);
        if (usesSdk == null) {
            usesSdk = manifest.newElement(TAG_uses_sdk);
        }
        ResXmlAttribute attribute = usesSdk.getOrCreateAndroidAttribute(NAME_targetSdkVersion, ID_targetSdkVersion);
        attribute.setTypeAndData(ValueType.DEC, version);
    }

    @Override
    public Integer getCompileSdkVersion() {
        return this.getManifestAttributeInt(ID_compileSdkVersion);
    }

    @Override
    public void setCompileSdkVersion(int version) {
        this.setManifestAttributeInt(NAME_compileSdkVersion, ID_compileSdkVersion, version);
    }

    @Override
    public String getCompileSdkVersionCodename() {
        return this.getManifestAttributeString(ID_compileSdkVersionCodename);
    }

    @Override
    public void setCompileSdkVersionCodename(String name) {
        this.setManifestAttributeString(NAME_compileSdkVersionCodename, ID_compileSdkVersionCodename, name);
    }

    private String getManifestAttributeString(int resourceId) {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByResourceId(resourceId);
        if (attribute == null || attribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return attribute.getValueAsString();
    }

    private void setManifestAttributeString(String attributeName, int resourceId, String value) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAndroidAttribute(attributeName, resourceId);
        attribute.setValueAsString(value);
    }

    private void setManifestAttributeInt(String attributeName, int resourceId, int value) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAndroidAttribute(attributeName, resourceId);
        attribute.setTypeAndData(ValueType.DEC, value);
    }

    private Integer getManifestAttributeInt(int resourceId) {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        ResXmlAttribute attribute = manifestElement.searchAttributeByResourceId(resourceId);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    public ResXmlElement getOrCreateApplicationElement() {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlElement application = manifestElement.getElement(TAG_application);
        if (application == null) {
            application = manifestElement.newElement(TAG_application);
        }
        return application;
    }

    public ResXmlElement getApplicationElement() {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        return manifestElement.getElement(TAG_application);
    }

    public ResXmlElement getManifestElement() {
        return this.getElement(AndroidManifest.TAG_manifest);
    }

    public void ensureFullClassNames() {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return;
        }
        Iterator iterator = application.recursiveAttributes();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = (ResXmlAttribute)iterator.next();
            if (attribute.getNameId() != ID_name || attribute.getValueType() != ValueType.STRING) continue;
            attribute.setValueAsString(this.fullClassName(attribute.getValueAsString()));
        }
        application.refresh();
    }

    public String fullClassName(String name) {
        if (name == null || name.length() == 0 || name.charAt(0) != '.') {
            return name;
        }
        String packageName = this.getPackageName();
        if (packageName == null) {
            return name;
        }
        return packageName + name;
    }

    private ResXmlElement getOrCreateManifestElement() {
        return this.getOrCreateElement(AndroidManifest.TAG_manifest);
    }

    public Iterator<ResXmlElement> getAndroidNameElements(String tag, String name) {
        return this.recursiveElements((T element) -> element.equalsName(tag) && name.equals(AndroidManifestBlock.getAndroidNameValue(element)));
    }

    @Override
    public String toString() {
        this.touchChildNodesForDebug();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        builder.append(NAME_PACKAGE).append("=").append(this.getPackageName());
        builder.append(", ").append(NAME_versionCode).append("=").append(this.getVersionCode());
        builder.append(", ").append(NAME_versionName).append("=").append(this.getVersionName());
        builder.append(", ").append(NAME_compileSdkVersion).append("=").append(this.getCompileSdkVersion());
        builder.append(", ").append(NAME_compileSdkVersionCodename).append("=").append(this.getCompileSdkVersionCodename());
        List<String> allPermissions = this.getUsesPermissions();
        builder.append(", PERMISSIONS[");
        boolean appendOnce = false;
        for (String permissions : allPermissions) {
            if (appendOnce) {
                builder.append(", ");
            }
            builder.append(permissions);
            appendOnce = true;
        }
        builder.append("]");
        builder.append("}");
        return builder.toString();
    }

    public static String getAndroidNameValue(ResXmlElement element) {
        ResXmlAttribute attribute = element.searchAttributeByResourceId(ID_name);
        if (attribute != null) {
            return attribute.getValueAsString();
        }
        return null;
    }

    public static boolean isAndroidManifestBlock(ResXmlDocument xmlBlock) {
        if (xmlBlock == null) {
            return false;
        }
        return xmlBlock.getElement(AndroidManifest.TAG_manifest) != null;
    }

    public static AndroidManifestBlock load(File file) throws IOException {
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        manifestBlock.readBytes(new BlockReader(file));
        return manifestBlock;
    }

    public static AndroidManifestBlock load(InputStream inputStream) throws IOException {
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        manifestBlock.readBytes(inputStream);
        return manifestBlock;
    }

    public static AndroidManifestBlock empty() {
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        manifestBlock.getOrCreateElement(EMPTY_MANIFEST_TAG);
        return manifestBlock;
    }
}

