/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public class PolicyFlag {
    public static final String ATTR_type = ObjectsUtil.of("type");
    public static final PolicyFlag PUBLIC = new PolicyFlag(1, "public");
    public static final PolicyFlag SYSTEM_PARTITION = new PolicyFlag(2, "system");
    public static final PolicyFlag VENDOR_PARTITION = new PolicyFlag(4, "vendor");
    public static final PolicyFlag PRODUCT_PARTITION = new PolicyFlag(8, "product");
    public static final PolicyFlag SIGNATURE = new PolicyFlag(16, "signature");
    public static final PolicyFlag ODM_PARTITION = new PolicyFlag(32, "odm");
    public static final PolicyFlag OEM_PARTITION = new PolicyFlag(64, "oem");
    public static final PolicyFlag ACTOR_SIGNATURE = new PolicyFlag(128, "actor");
    public static final PolicyFlag CONFIG_SIGNATURE = new PolicyFlag(256, "config");
    private static final PolicyFlag[] VALUES;
    private static final Map<String, PolicyFlag> nameMap;
    private final int flag;
    private final String name;

    private PolicyFlag(int flag, String name) {
        this.flag = flag;
        this.name = name;
    }

    public int flag() {
        return this.flag;
    }

    public String name() {
        return this.name;
    }

    public boolean isSet(int flagsValue) {
        int f = this.flag();
        return (f & flagsValue) == f;
    }

    public static PolicyFlag[] valuesOf(int flagValue) {
        if (flagValue == 0) {
            return null;
        }
        PolicyFlag[] values = VALUES;
        PolicyFlag[] tmp = new PolicyFlag[values.length];
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            PolicyFlag flag = values[i];
            if (!flag.isSet(flagValue)) continue;
            tmp[i] = flag;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count == tmp.length) {
            return tmp;
        }
        PolicyFlag[] results = new PolicyFlag[count];
        int j = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            results[j] = tmp[i];
            ++j;
        }
        return results;
    }

    public static int sum(PolicyFlag[] flagsList) {
        if (flagsList == null || flagsList.length == 0) {
            return 0;
        }
        int results = 0;
        for (PolicyFlag flags : flagsList) {
            if (flags == null) continue;
            results |= flags.flag();
        }
        return results;
    }

    public static boolean contains(PolicyFlag[] flagsList, PolicyFlag policyFlag) {
        if (flagsList == null || flagsList.length == 0) {
            return policyFlag == null;
        }
        if (policyFlag == null) {
            return false;
        }
        for (PolicyFlag flags : flagsList) {
            if (!policyFlag.equals(flags)) continue;
            return true;
        }
        return false;
    }

    public static int parse(XmlPullParser parser) throws IOException {
        String[] flagNames;
        String policyFlags = parser.getAttributeValue(null, ATTR_type);
        if (StringsUtil.isEmpty(policyFlags)) {
            return 0;
        }
        int result = 0;
        for (String name : flagNames = StringsUtil.split(policyFlags, '|')) {
            if ((name = name.trim()).length() == 0) continue;
            PolicyFlag flag = PolicyFlag.nameOf(name);
            if (flag == null) {
                throw new EncodeException(parser, "Unknown policy flag '" + name + "'");
            }
            result |= flag.flag();
        }
        return result;
    }

    public static void serialize(XmlSerializer serializer, int policyFlags) throws IOException {
        String type = PolicyFlag.toString(policyFlags);
        if (!StringsUtil.isEmpty(type)) {
            serializer.attribute(null, ATTR_type, type);
        }
    }

    public static String toString(int policyFlags) {
        if (policyFlags == 0) {
            return StringsUtil.EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (PolicyFlag policyFlag : VALUES) {
            if (!policyFlag.isSet(policyFlags)) continue;
            if (appendOnce) {
                builder.append('|');
            }
            builder.append(policyFlag.name());
            appendOnce = true;
        }
        return builder.toString();
    }

    public static String toString(PolicyFlag[] flagsList) {
        if (flagsList == null || flagsList.length == 0) {
            return StringsUtil.EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (PolicyFlag flags : flagsList) {
            if (flags == null) continue;
            if (appendOnce) {
                builder.append('|');
            }
            builder.append(flags.name());
            appendOnce = true;
        }
        return builder.toString();
    }

    public static PolicyFlag[] valuesOf(String flagsString) {
        if (flagsString == null) {
            return null;
        }
        flagsString = flagsString.trim();
        String[] namesList = flagsString.split("\\s*\\|\\s*");
        PolicyFlag[] tmp = new PolicyFlag[namesList.length];
        int count = 0;
        for (int i = 0; i < namesList.length; ++i) {
            PolicyFlag flags = PolicyFlag.nameOf(namesList[i]);
            if (flags == null) continue;
            tmp[i] = flags;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count == tmp.length) {
            return tmp;
        }
        PolicyFlag[] results = new PolicyFlag[count];
        int j = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            results[j] = tmp[i];
            ++j;
        }
        return results;
    }

    public static PolicyFlag nameOf(String name) {
        return nameMap.get(name);
    }

    static {
        PolicyFlag[] values = new PolicyFlag[]{PUBLIC, SYSTEM_PARTITION, VENDOR_PARTITION, PRODUCT_PARTITION, SIGNATURE, ODM_PARTITION, OEM_PARTITION, ACTOR_SIGNATURE, CONFIG_SIGNATURE};
        VALUES = values;
        HashMap<String, PolicyFlag> map = new HashMap<String, PolicyFlag>();
        nameMap = map;
        for (PolicyFlag policyFlag : values) {
            map.put(policyFlag.name(), policyFlag);
        }
    }
}

