/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.value.LibraryInfo;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;

public class LibraryInfoArray
extends BlockArray<LibraryInfo>
implements JSONConvert<JSONArray> {
    private final IntegerItem mInfoCount;

    public LibraryInfoArray(IntegerItem infoCount) {
        this.mInfoCount = infoCount;
    }

    public boolean containsLibraryInfo(String packageName) {
        for (LibraryInfo info : this.getChildes()) {
            if (!info.packageNameMatches(packageName)) continue;
            return true;
        }
        return false;
    }

    public LibraryInfo getOrCreate(int pkgId) {
        LibraryInfo info = this.getById(pkgId);
        if (info != null) {
            return info;
        }
        int index = this.size();
        this.ensureSize(index + 1);
        info = (LibraryInfo)this.get(index);
        info.setId(pkgId);
        return info;
    }

    public LibraryInfo getById(int pkgId) {
        for (LibraryInfo info : this.listItems()) {
            if (info == null || pkgId != info.getId()) continue;
            return info;
        }
        return null;
    }

    @Override
    public LibraryInfo newInstance() {
        return new LibraryInfo();
    }

    @Override
    protected void onRefreshed() {
        this.mInfoCount.set(this.size());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.setSize(this.mInfoCount.get());
        super.onReadBytes(reader);
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (LibraryInfo libraryInfo : this.listItems()) {
            JSONObject jsonObject = libraryInfo.toJson();
            if (jsonObject == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json == null) {
            return;
        }
        int length = json.length();
        this.ensureSize(length);
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            LibraryInfo libraryInfo = (LibraryInfo)this.get(i);
            libraryInfo.fromJson(jsonObject);
        }
    }

    public void merge(LibraryInfoArray infoArray) {
        if (infoArray == null || infoArray == this || infoArray.size() == 0) {
            return;
        }
        for (LibraryInfo info : infoArray.listItems()) {
            LibraryInfo exist = this.getOrCreate(info.getId());
            exist.merge(info);
        }
    }
}

