/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.io.ZipFileOutput;
import com.reandroid.archive.io.ZipOutput;
import com.reandroid.archive.writer.BufferFileInput;
import com.reandroid.archive.writer.BufferFileOutput;
import com.reandroid.archive.writer.EntryBuffer;
import com.reandroid.archive.writer.OutputSource;
import com.reandroid.archive.writer.ZipAligner;
import java.io.IOException;
import java.nio.channels.FileChannel;

class FileOutputSource
extends OutputSource {
    private EntryBuffer entryBuffer;

    FileOutputSource(InputSource inputSource) {
        super(inputSource);
    }

    void makeBuffer(BufferFileInput input, BufferFileOutput output) throws IOException {
        EntryBuffer entryBuffer = this.entryBuffer;
        if (entryBuffer != null) {
            return;
        }
        entryBuffer = this.makeFromEntry();
        if (entryBuffer != null) {
            this.entryBuffer = entryBuffer;
            return;
        }
        this.entryBuffer = this.writeBuffer(input, output);
    }

    private EntryBuffer writeBuffer(BufferFileInput input, ZipOutput output) throws IOException {
        long offset = output.position();
        this.writeBuffer(output);
        long length = output.position() - offset;
        return new EntryBuffer(input, offset, length);
    }

    EntryBuffer makeFromEntry() {
        return null;
    }

    void writeApk(ZipFileOutput zipFileOutput, ZipAligner zipAligner) throws IOException {
        this.logLargeFileWrite();
        EntryBuffer entryBuffer = this.entryBuffer;
        FileChannel input = entryBuffer.getZipFileInput().getFileChannel();
        input.position(entryBuffer.getOffset());
        this.writeLFH(zipFileOutput, zipAligner);
        this.writeData(input, entryBuffer.getLength(), zipFileOutput);
        this.writeDD(zipFileOutput);
    }

    private void writeData(FileChannel input, long length, ZipFileOutput apkFileWriter) throws IOException {
        long offset = apkFileWriter.position();
        LocalFileHeader lfh = this.getLocalFileHeader();
        lfh.setFileOffset(offset);
        apkFileWriter.write(input, length);
    }
}

