/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import com.reandroid.common.FileChannelInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FileInputSource
extends InputSource {
    private final File file;

    public FileInputSource(File file, String name) {
        super(name);
        this.file = file;
    }

    @Override
    public byte[] getBytes(int length) throws IOException {
        return FileChannelInputStream.read(this.getFile(), length);
    }

    @Override
    public long getLength() {
        return this.getFile().length();
    }

    @Override
    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    @Override
    public FileChannelInputStream openStream() throws IOException {
        return new FileChannelInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }
}

