/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.DexDecoder;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.apkeditor.smali.ResourceComment;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.SmaliWriterSetting;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.VersionMap;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;

public class SmaliDecompiler
implements DexDecoder {
    private final TableBlock tableBlock;
    private final DecompileOptions decompileOptions;
    private ResourceComment mComment;
    private Opcodes mCurrentOpcodes;
    private APKLogger apkLogger;

    public SmaliDecompiler(TableBlock tableBlock, DecompileOptions decompileOptions) {
        this.tableBlock = tableBlock;
        this.decompileOptions = decompileOptions;
    }

    @Deprecated
    public SmaliDecompiler(TableBlock tableBlock) {
        this(tableBlock, new DecompileOptions());
    }

    @Override
    public void decodeDex(DexFileInputSource inputSource, File mainDir) throws IOException {
        this.logMessage("Baksmali: " + inputSource.getAlias());
        if ("internal".equals(this.decompileOptions.dexLib)) {
            this.disassembleWithInternalDexLib(inputSource, mainDir);
        } else {
            this.disassembleWithJesusFrekeLib(inputSource, mainDir);
        }
        this.writeDexCache(inputSource, mainDir);
    }

    @Override
    public void decodeDex(ApkModule apkModule, File mainDirectory) throws IOException {
        if (!"internal".equals(this.decompileOptions.dexLib)) {
            DexDecoder.super.decodeDex(apkModule, mainDirectory);
            return;
        }
        DexDirectory directory = (DexDirectory)apkModule.getTag(DexDirectory.class);
        if (directory == null) {
            if (apkModule.listDexFiles().size() > this.decompileOptions.loadDex) {
                DexDecoder.super.decodeDex(apkModule, mainDirectory);
                return;
            }
            this.logMessage("Loading full dex files: " + apkModule.listDexFiles().size());
            Predicate<SectionType<Object>> filter = this.decompileOptions.noDexDebug ? sectionType -> sectionType != SectionType.DEBUG_INFO : null;
            directory = DexDirectory.fromZip(apkModule.getZipEntryMap(), filter);
        }
        File smali = this.toSmaliRoot(mainDirectory);
        SmaliWriterSetting setting = new SmaliWriterSetting();
        if (this.tableBlock != null) {
            setting.setResourceIdComment(this.tableBlock.pickOne());
        }
        setting.addClassComments(directory);
        setting.addMethodComments(directory);
        setting.setLocalRegistersCount(true);
        SmaliWriter smaliWriter = new SmaliWriter();
        smaliWriter.setWriterSetting(setting);
        this.logMessage("Baksmali ...");
        directory.writeSmali(smaliWriter, smali);
        directory.close();
        List<DexFileInputSource> dexList = apkModule.listDexFiles();
        for (DexFileInputSource inputSource : dexList) {
            this.writeDexCache(inputSource, mainDirectory);
        }
    }

    private void disassembleWithJesusFrekeLib(DexFileInputSource inputSource, File mainDir) throws IOException {
        File dir = this.toOutDir(inputSource, mainDir);
        BaksmaliOptions options = new BaksmaliOptions();
        options.localsDirective = true;
        options.sequentialLabels = true;
        options.skipDuplicateLineNumbers = true;
        options.debugInfo = !this.decompileOptions.noDexDebug;
        options.dumpMarkers = this.decompileOptions.dexMarkers;
        options.setCommentProvider(this.getComment());
        DexBackedDexFile dexFile = this.getInputDexFile(inputSource, options);
        Baksmali.disassembleDexFile(dexFile, dir, 1, options);
    }

    private void disassembleWithInternalDexLib(DexFileInputSource inputSource, File mainDir) throws IOException {
        Predicate<SectionType<Object>> filter = this.decompileOptions.noDexDebug ? sectionType -> sectionType != SectionType.DEBUG_INFO : null;
        DexFile dexFile = DexFile.read(inputSource.openStream(), filter);
        dexFile.setSimpleName(inputSource.getAlias());
        if (dexFile.isMultiLayout()) {
            this.logMessage("Multi layout dex file: " + inputSource.getAlias() + "version = " + dexFile.getVersion() + ", layouts = " + dexFile.size());
        }
        SmaliWriterSetting setting = new SmaliWriterSetting();
        if (this.tableBlock != null) {
            setting.setResourceIdComment(this.tableBlock.pickOne());
        }
        setting.addClassComments(dexFile);
        setting.addMethodComments(dexFile);
        SmaliWriter smaliWriter = new SmaliWriter();
        smaliWriter.setWriterSetting(setting);
        dexFile.writeSmali(smaliWriter, this.toSmaliRoot(mainDir));
        dexFile.close();
    }

    private void writeDexCache(DexFileInputSource inputSource, File mainDir) throws IOException {
        File cache = new File(mainDir, ".cache");
        cache = new File(cache, inputSource.getAlias());
        inputSource.write(cache);
    }

    private File toOutDir(DexFileInputSource inputSource, File mainDir) {
        String name = "classes";
        int num = inputSource.getDexNumber();
        if (num != 0) {
            name = name + num;
        }
        File dir = this.toSmaliRoot(mainDir);
        if (!(dir = new File(dir, name)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File toSmaliRoot(File mainDir) {
        return new File(mainDir, DexDecoder.SMALI_DIRECTORY_NAME);
    }

    private DexBackedDexFile getInputDexFile(DexFileInputSource inputSource, BaksmaliOptions options) throws IOException {
        int api;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        inputSource.write(outputStream);
        outputStream.close();
        byte[] bytes = outputStream.toByteArray();
        int version = HeaderItem.getVersion(bytes, 0);
        options.apiLevel = api = VersionMap.mapDexVersionToApi(version);
        Opcodes opcodes = this.mCurrentOpcodes;
        if (opcodes == null || api != opcodes.api) {
            this.mCurrentOpcodes = opcodes = Opcodes.forApi(api);
        }
        return new DexBackedDexFile(opcodes, bytes);
    }

    public ResourceComment getComment() {
        ResourceComment comment = this.mComment;
        if (comment == null && this.tableBlock != null) {
            this.mComment = comment = new ResourceComment(this.tableBlock);
        }
        return this.mComment;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }
}

