/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeNameMap
implements Comparator<TypeName> {
    private final Map<Integer, TypeName> map = new HashMap<Integer, TypeName>();

    public boolean contains(String name) {
        for (TypeName typeName : this.map.values()) {
            if (!Objects.equals(name, typeName.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int id) {
        return this.map.containsKey(id &= 0xFFFF0000);
    }

    public XMLDocument toXMLDocument() {
        XMLDocument xmlDocument = new XMLDocument();
        XMLElement documentElement = new XMLElement("resources");
        xmlDocument.setDocumentElement(documentElement);
        for (TypeName typeName : this.listTypeNames()) {
            documentElement.add(typeName.toXMLElement());
        }
        return xmlDocument;
    }

    public List<TypeName> listTypeNames() {
        ArrayList<TypeName> results = new ArrayList<TypeName>(this.map.values());
        results.sort(this);
        return results;
    }

    public int count() {
        return this.map.size();
    }

    public void add(XMLDocument xmlDocument) {
        XMLElement documentElement = xmlDocument.getDocumentElement();
        if (documentElement == null) {
            return;
        }
        Iterator<? extends XMLElement> iterator = documentElement.getElements();
        while (iterator.hasNext()) {
            this.add(TypeName.fromXMLElement(iterator.next()));
        }
    }

    public void add(int id, String name) {
        this.add(new TypeName(id, name));
    }

    public void add(TypeName typeName) {
        this.map.remove(typeName.getPackageTypeId());
        this.map.put(typeName.getPackageTypeId(), typeName);
    }

    @Override
    public int compare(TypeName typeName1, TypeName typeName2) {
        return typeName1.compareTo(typeName2);
    }

    private static int decodeHex(String hex) {
        long l = Long.decode(hex);
        return (int)l;
    }

    public static class TypeName
    implements Comparable<TypeName> {
        private final int packageTypeId;
        private final String name;

        public TypeName(int packageTypeId, String name) {
            this.packageTypeId = packageTypeId & 0xFFFF0000;
            this.name = name;
        }

        public XMLElement toXMLElement() {
            XMLElement element = new XMLElement("type");
            element.setAttribute("id", this.getHexId());
            element.setAttribute("name", this.getName());
            return element;
        }

        public String getHexId() {
            return String.format("0x%08x", this.getPackageTypeId());
        }

        public int getPackageTypeId() {
            return this.packageTypeId;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeName typeName = (TypeName)o;
            return this.packageTypeId == typeName.packageTypeId;
        }

        public int hashCode() {
            return Objects.hash(this.packageTypeId);
        }

        public String toString() {
            return this.getHexId() + ":" + this.getName();
        }

        public static TypeName fromXMLElement(XMLElement element) {
            int id = TypeNameMap.decodeHex(element.getAttributeValue("id"));
            String name = element.getAttributeValue("name");
            return new TypeName(id, name);
        }

        @Override
        public int compareTo(TypeName typeName) {
            return Integer.compare(this.getPackageTypeId() >> 16, typeName.getPackageTypeId() >> 16);
        }
    }
}

