/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.refactor.AutoRefactor;
import com.reandroid.apkeditor.refactor.PublicXmlRefactor;
import com.reandroid.apkeditor.refactor.RefactorOptions;
import com.reandroid.apkeditor.refactor.StringValueNameGenerator;
import com.reandroid.apkeditor.refactor.TypeNameRefactor;
import com.reandroid.arsc.chunk.TableBlock;
import java.io.File;
import java.io.IOException;

public class Refactor
extends CommandExecutor<RefactorOptions> {
    public Refactor(RefactorOptions options) {
        super(options, "[REFACTOR] ");
    }

    @Override
    public void runCommand() throws IOException {
        String message;
        RefactorOptions options = (RefactorOptions)this.getOptions();
        this.delete(options.outputFile);
        this.logMessage("Loading apk: " + options.inputFile);
        ApkModule module = ApkModule.loadApkFile(this, options.inputFile, new File[0]);
        if (!module.hasTableBlock()) {
            throw new IOException("Don't have " + TableBlock.FILE_NAME);
        }
        String protect = Util.isProtected(module);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        if (options.fixTypeNames) {
            TypeNameRefactor typeNameRefactor = new TypeNameRefactor(module);
            typeNameRefactor.setApkLogger(this);
            typeNameRefactor.refactor();
        }
        if (options.publicXml != null) {
            this.logMessage("Renaming from: " + options.publicXml);
            PublicXmlRefactor publicXmlRefactor = new PublicXmlRefactor(module, options.publicXml);
            publicXmlRefactor.refactor();
        } else {
            this.logMessage("Auto refactoring ...");
            AutoRefactor autoRefactor = new AutoRefactor(module);
            autoRefactor.refactor();
            this.logMessage("Auto renamed entries");
            StringValueNameGenerator generator = new StringValueNameGenerator(module.getTableBlock());
            generator.refactor();
        }
        if (options.cleanMeta) {
            this.logMessage("Clearing META-INF ...");
            Refactor.clearMeta(module);
        }
        if ((message = module.refreshTable()) != null) {
            this.logMessage(message);
        }
        this.logMessage("Writing apk ...");
        module.writeApk(options.outputFile);
        this.logMessage("Saved to: " + options.outputFile);
    }
}

