/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.protect.Confuser;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.arsc.ARSCLib;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.TypeStringPool;

public class TableConfuser
extends Confuser {
    public TableConfuser(Protector protector) {
        super(protector, "TableConfuser: ");
    }

    @Override
    public void confuse() {
        this.logMessage("Confusing ...");
        this.confuseWithUnknownChunk();
        this.confuseTypeNames();
    }

    private void confuseWithUnknownChunk() {
        ApkModule apkModule = this.getApkModule();
        TableBlock tableBlock = apkModule.getTableBlock();
        UnknownChunk unknownChunk = new UnknownChunk();
        FixedLengthString fixedLengthString = new FixedLengthString(256);
        fixedLengthString.set(APKEditor.getRepo());
        ByteArray extra = ((HeaderBlock)unknownChunk.getHeaderBlock()).getExtraBytes();
        byte[] bytes = fixedLengthString.getBytes();
        extra.setSize(bytes.length);
        extra.putByteArray(0, bytes);
        fixedLengthString.set(ARSCLib.getRepo());
        extra = unknownChunk.getBody();
        bytes = fixedLengthString.getBytes();
        extra.setSize(bytes.length);
        extra.putByteArray(0, bytes);
        fixedLengthString.set(ARSCLib.getRepo());
        unknownChunk.refresh();
        tableBlock.getFirstPlaceHolder().setItem(unknownChunk);
        tableBlock.refresh();
    }

    private void confuseTypeNames() {
        if (this.isKeepAllTypes()) {
            this.logMessage("Skip type names");
            return;
        }
        this.logMessage("Type names ...");
        ApkModule apkModule = this.getApkModule();
        TableBlock tableBlock = apkModule.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            TypeStringPool pool = packageBlock.getTypeStringPool();
            for (TypeString typeString : pool) {
                String replace;
                String type = typeString.get();
                if (type.equals(replace = this.getReplacement(type))) continue;
                typeString.set(replace);
                this.logVerbose("'" + type + "' -> '" + typeString.get() + "'");
            }
        }
        tableBlock.refresh();
    }

    private String getReplacement(String type) {
        if (this.isKeepType(type)) {
            return type;
        }
        String replacement = "attr".equals(type) ? "style" : ("style".equals(type) ? "plurals" : ("id".equals(type) ? "attr" : ("mipmap".equals(type) ? "id" : type)));
        if (this.isKeepType(replacement)) {
            replacement = type;
        }
        return replacement;
    }
}

