/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.apkeditor.protect.Confuser;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.apkeditor.utils.CyclicIterator;
import com.reandroid.archive.Archive;

public class FileNameConfuser
extends Confuser {
    private final CyclicIterator<String> namesIterator;

    public FileNameConfuser(Protector protector) {
        super(protector, "FileNameConfuser: ");
        this.namesIterator = new CyclicIterator<String>(protector.getOptions().loadFileNameDictionary());
    }

    @Override
    public void confuse() {
        this.logMessage("Confusing ...");
        ApkModule apkModule = this.getApkModule();
        UncompressedFiles uf = apkModule.getUncompressedFiles();
        for (ResFile resFile : this.getApkModule().listResFiles()) {
            int method = resFile.getInputSource().getMethod();
            String pathNew = this.generateNewPath(resFile);
            if (pathNew == null) continue;
            String path = resFile.getFilePath();
            if (method == Archive.STORED) {
                uf.replacePath(path, pathNew);
            }
            resFile.setFilePath(pathNew);
            this.onPathChanged(path, pathNew);
        }
    }

    private String generateNewPath(ResFile resFile) {
        if (this.isKeepType(resFile.pickOne().getTypeName())) {
            return null;
        }
        return this.generateNewPath(resFile.getFilePath());
    }

    private String generateNewPath(String path) {
        CyclicIterator<String> iterator = this.namesIterator;
        iterator.resetCycleCount();
        while (iterator.getCycleCount() == 0) {
            String newPath = FileNameConfuser.replaceSimpleName(path, iterator.next());
            if (this.containsFilePath(newPath)) continue;
            return newPath;
        }
        return null;
    }

    private static String replaceSimpleName(String path, String symbol) {
        String simpleName;
        String dirName;
        int i = path.lastIndexOf(47);
        if (i < 0) {
            dirName = "";
            simpleName = path;
        } else {
            dirName = path.substring(0, ++i);
            simpleName = path.substring(i);
        }
        i = simpleName.lastIndexOf(46);
        String ext = i < 0 ? "." : (simpleName.endsWith(".9.png") ? ".9.png" : simpleName.substring(i));
        return dirName + symbol + ext;
    }
}

