/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.archive.block.CertificateBlock;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.model.DexSectionInfo;
import com.reandroid.dex.sections.Marker;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeList;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.kxml2.KXmlSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class InfoWriterXml
extends InfoWriter {
    private KXmlSerializer mSerializer;
    private int mIndent;
    private static final int INDENT = 3;
    private static final String TAG_INFO = "info";

    public InfoWriterXml(Writer writer) {
        super(writer);
    }

    @Override
    public void writeStringPool(String source, StringPool<?> stringPool) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        this.mIndent = indent = this.mIndent + 2;
        serializer.startTag(null, "string-pool");
        serializer.attribute(null, "source", source);
        serializer.attribute(null, "count", Integer.toString(stringPool.size()));
        serializer.attribute(null, "styles", Integer.toString(stringPool.countStyles()));
        serializer.attribute(null, "sorted", String.valueOf(((StringPoolHeader)stringPool.getHeaderBlock()).isSorted()));
        serializer.attribute(null, "utf8", String.valueOf(stringPool.isUtf8()));
        serializer.attribute(null, "bytes", String.valueOf(((StringPoolHeader)stringPool.getHeaderBlock()).getChunkSize()));
        int size = stringPool.size();
        for (int i = 0; i < size; ++i) {
            Object item = stringPool.get(i);
            this.writeIndent(serializer, indent);
            serializer.startTag(null, "string");
            serializer.attribute(null, "id", Integer.toString(((Block)item).getIndex()));
            ((StringItem)item).serializeText(serializer);
            serializer.endTag(null, "string");
        }
        this.writeIndent(serializer, indent -= 2);
        serializer.endTag(null, "string-pool");
        serializer.flush();
    }

    @Override
    public void writeXmlDocument(String sourcePath, ResXmlDocument xmlDocument) throws IOException {
        KXmlSerializer serializer = this.getSerializer();
        serializer.flush();
        boolean decode = false;
        if (xmlDocument.getPackageBlock() != null) {
            decode = true;
        }
        Writer writer = this.getWriter();
        writer.write("\n");
        String name = "document";
        serializer.startTag(null, name);
        serializer.attribute(null, "source-path", sourcePath);
        XmlSerializer documentSerializer = this.newSerializer();
        Iterator<ResXmlNode> iterator = xmlDocument.iterator();
        while (iterator.hasNext()) {
            ResXmlNode xmlNode = iterator.next();
            xmlNode.serialize(documentSerializer, decode);
        }
        documentSerializer.flush();
        writer.write("\n");
        serializer.endTag(null, name);
    }

    @Override
    public void writeCertificates(List<CertificateBlock> certificateList, boolean base64) throws IOException {
        ComputeList<String, CertificateBlock> infoList = new ComputeList<String, CertificateBlock>(certificateList, certificateBlock -> {
            String value = certificateBlock.printCertificate();
            if (base64) {
                value = value + "\n" + InfoWriterXml.toBase64(certificateBlock.getCertificateBytes());
            }
            return value;
        });
        this.writeArray("certificates", infoList.toArray());
    }

    @Override
    public void writeDexInfo(DexFile dexFile, boolean writeSectionInfo) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "dex");
        serializer.attribute(null, "name", dexFile.getFileName());
        serializer.attribute(null, "version", Integer.toString(dexFile.getVersion()));
        if (dexFile.isMultiLayout()) {
            int size = dexFile.size();
            serializer.attribute(null, "layouts", Integer.toString(size));
            for (int i = 0; i < size; ++i) {
                this.writeDexLayout(serializer, dexFile.getLayout(i));
            }
        } else if (dexFile.size() != 0) {
            this.writeDexLayout(serializer, dexFile.getFirst());
        } else {
            serializer.text("EMPTY DEX");
        }
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "dex");
        this.mIndent = indent = this.mIndent - 2;
    }

    private void writeDexLayout(KXmlSerializer serializer, DexLayout layout) throws IOException {
        List<Marker> markersList;
        int indent;
        this.mIndent = indent = this.mIndent + 2;
        boolean tagOpened = false;
        if (layout.isMultiLayoutEntry()) {
            this.writeIndent(serializer, indent);
            serializer.startTag(null, "layout");
            this.mIndent = indent = this.mIndent + 2;
            tagOpened = true;
            serializer.attribute(null, "name", layout.getName());
            serializer.attribute(null, "version", Integer.toString(layout.getVersion()));
        }
        if ((markersList = CollectionUtil.toList(layout.getMarkers())).size() != 0) {
            this.writeArray("markers", markersList.toArray());
        }
        this.writeSectionInfo(serializer, layout);
        this.mIndent = indent -= 2;
        if (tagOpened) {
            this.writeIndent(serializer, indent);
            serializer.endTag(null, "layout");
            this.mIndent = indent -= 2;
        }
    }

    private void writeSectionInfo(KXmlSerializer serializer, DexLayout layout) throws IOException {
        Iterator<DexSectionInfo> iterator = layout.getSectionInfo();
        if (!iterator.hasNext()) {
            return;
        }
        int indent = this.mIndent;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "dex-sections");
        while (iterator.hasNext()) {
            DexSectionInfo sectionInfo = iterator.next();
            this.writeIndent(serializer, indent + 2);
            serializer.startTag(null, "section");
            serializer.attribute(null, "name", sectionInfo.getSectionType().getName());
            serializer.attribute(null, "count", Integer.toString(sectionInfo.getCount()));
            serializer.attribute(null, "offset", Integer.toString(sectionInfo.getOffset()));
            serializer.endTag(null, "section");
        }
        this.mIndent = indent;
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "dex-sections");
    }

    @Override
    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "package");
        serializer.attribute(null, "id", HexUtil.toHex2((byte)packageBlock.getId()));
        serializer.attribute(null, "name", packageBlock.getName());
        packageBlock.sortTypes();
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            if (!this.contains(specTypePair, typeFilters)) continue;
            this.writeResources(specTypePair, writeEntries);
        }
        this.writeIndent(serializer, indent);
        this.mIndent = indent -= 2;
        serializer.endTag(null, "package");
    }

    public void writeResources(SpecTypePair specTypePair, boolean writeEntries) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "type");
        serializer.attribute(null, "name", specTypePair.getTypeName());
        serializer.attribute(null, "id", Integer.toString(specTypePair.getId()));
        serializer.attribute(null, "entryCount", Integer.toString(specTypePair.getHighestEntryCount()));
        Iterator<ResourceEntry> iterator = specTypePair.getResources();
        while (iterator.hasNext()) {
            ResourceEntry resourceEntry = iterator.next();
            this.writeResources(resourceEntry, writeEntries);
        }
        this.writeIndent(serializer, indent);
        this.mIndent = indent -= 2;
        serializer.endTag(null, "type");
        serializer.flush();
    }

    @Override
    public void writeResources(ResourceEntry resourceEntry, boolean writeEntries) throws IOException {
        int indent;
        if (resourceEntry.isEmpty()) {
            return;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "resource");
        serializer.attribute(null, "id", HexUtil.toHex8(resourceEntry.getResourceId()));
        serializer.attribute(null, "type", resourceEntry.getType());
        serializer.attribute(null, "name", resourceEntry.getName());
        if (writeEntries) {
            this.writeEntries(resourceEntry);
            this.writeIndent(serializer, indent);
        }
        this.mIndent = indent -= 2;
        serializer.endTag(null, "resource");
        serializer.flush();
    }

    public void writeEntries(ResourceEntry entryList) throws IOException {
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
    }

    public void writeEntry(Entry entry) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "config");
        serializer.attribute(null, "qualifiers", entry.getResConfig().getQualifiers());
        if (entry.isComplex()) {
            this.writeBagEntry(entry);
        } else {
            this.writeResEntry(entry);
        }
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "config");
        this.mIndent = indent -= 2;
    }

    private void writeResEntry(Entry entry) throws IOException {
        int indent;
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "value");
        serializer.attribute(null, "type", resValue.getValueType().name());
        serializer.text(InfoWriterXml.getValueAsString(resValue));
        serializer.endTag(null, "value");
        this.mIndent = indent -= 2;
    }

    private void writeBagEntry(Entry entry) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "bag");
        serializer.attribute(null, "parent", HexUtil.toHex8(((ResTableMapEntry)entry.getTableEntry()).getParentId()));
        ResValueMapArray mapArray = entry.getResValueMapArray();
        for (ResValueMap resValueMap : mapArray.getChildes()) {
            this.writeValueMap(resValueMap);
        }
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "bag");
        this.mIndent = indent -= 2;
    }

    private void writeValueMap(ResValueMap resValueMap) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "value");
        serializer.attribute(null, "name", HexUtil.toHex8(resValueMap.getNameId()));
        serializer.attribute(null, "type", resValueMap.getValueType().name());
        serializer.text(InfoWriterXml.getValueAsString(resValueMap));
        serializer.endTag(null, "value");
        this.mIndent = indent -= 2;
    }

    @Override
    public void writePackageNames(Collection<PackageBlock> packageBlocks) throws IOException {
        if (packageBlocks == null || packageBlocks.size() == 0) {
            return;
        }
        int level = 3;
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, "resource-packages");
        serializer.attribute(null, "count", Integer.toString(packageBlocks.size()));
        level += 2;
        for (PackageBlock packageBlock : packageBlocks) {
            this.writeIndent(serializer, level);
            serializer.startTag(null, "package");
            serializer.attribute(null, "id", HexUtil.toHex2((byte)packageBlock.getId()));
            serializer.attribute(null, "name", packageBlock.getName());
            serializer.endTag(null, "package");
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, "resource-packages");
        serializer.flush();
    }

    @Override
    public void writeEntries(String name, List<Entry> entryList) throws IOException {
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        Entry first = entryList.get(0);
        int level = 3;
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, name);
        serializer.attribute(null, "count", Integer.toString(entryList.size()));
        serializer.attribute(null, "id", HexUtil.toHex8(first.getResourceId()));
        serializer.attribute(null, "type", first.getTypeName());
        serializer.attribute(null, "name", first.getName());
        level += 2;
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void writeArray(String name, Object[] values) throws IOException {
        if (values == null) {
            return;
        }
        int level = this.mIndent;
        if (level == 0) {
            level = 3;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, name);
        serializer.attribute(null, "count", Integer.toString(values.length));
        level += 2;
        for (Object value : values) {
            String text = InfoWriterXml.toString(value);
            if (text == null) {
                text = "";
            }
            this.writeIndent(serializer, level);
            serializer.startTag(null, "item");
            serializer.text(text);
            serializer.endTag(null, "item");
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void writeNameValue(String name, Object value) throws IOException {
        String text = InfoWriterXml.toString(value);
        if (text == null) {
            return;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, 3);
        serializer.startTag(null, name);
        serializer.text(text);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void flush() throws IOException {
        KXmlSerializer serializer = this.mSerializer;
        if (serializer != null) {
            this.writeIndent(serializer, 0);
            serializer.endTag(null, TAG_INFO);
            serializer.endDocument();
            this.writeIndent(serializer, 0);
            serializer.flush();
        }
    }

    private void writeIndent(KXmlSerializer serializer, int level) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        for (int i = 0; i < level; ++i) {
            builder.append(' ');
        }
        serializer.text(builder.toString());
    }

    private KXmlSerializer getSerializer() throws IOException {
        KXmlSerializer serializer = this.mSerializer;
        if (serializer != null) {
            return serializer;
        }
        serializer = new KXmlSerializer();
        serializer.setOutput(this.getWriter());
        serializer.startDocument("utf-8", null);
        this.writeIndent(serializer, 0);
        serializer.startTag(null, TAG_INFO);
        this.mSerializer = serializer;
        return serializer;
    }

    private XmlSerializer newSerializer() throws IOException {
        KXmlSerializer current = this.mSerializer;
        if (current != null) {
            current.flush();
        }
        Writer writer = this.getWriter();
        writer.flush();
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(writer);
        XMLUtil.setFeatureSafe(serializer, XMLUtil.FEATURE_INDENT_OUTPUT, true);
        return serializer;
    }
}

