/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleJsonEncoder;
import com.reandroid.apk.ApkModuleRawEncoder;
import com.reandroid.apk.ApkModuleXmlEncoder;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.compile.BuildOptions;
import com.reandroid.apkeditor.smali.SmaliCompiler;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.arsc.coder.xml.XmlCoder;
import java.io.File;
import java.io.IOException;

public class Builder
extends CommandExecutor<BuildOptions> {
    public Builder(BuildOptions options) {
        super(options, "[BUILD] ");
    }

    @Override
    public void runCommand() throws IOException {
        BuildOptions options = (BuildOptions)this.getOptions();
        this.delete(options.outputFile);
        String type = options.type;
        if ("sig".equals(type)) {
            this.restoreSignatures();
        } else if ("raw".equals(type)) {
            this.buildRaw();
        } else if ("xml".equals(type)) {
            this.buildXml();
        } else if ("json".equals(type)) {
            this.buildJson();
        }
    }

    private void restoreSignatures() throws IOException {
        this.logMessage("Restoring signatures ...");
        BuildOptions options = (BuildOptions)this.getOptions();
        ArchiveFile archive = new ArchiveFile(options.inputFile);
        ApkFileWriter apkWriter = new ApkFileWriter(options.outputFile, archive.getInputSources());
        apkWriter.setAPKLogger(this);
        ApkSignatureBlock apkSignatureBlock = new ApkSignatureBlock();
        apkSignatureBlock.scanSplitFiles(options.signaturesDirectory);
        apkWriter.setApkSignatureBlock(apkSignatureBlock);
        this.logMessage("Writing apk...");
        apkWriter.write();
        this.logMessage("Saved to: " + options.outputFile);
        apkWriter.close();
    }

    public void buildJson() throws IOException {
        this.logMessage("Scanning JSON directory ...");
        ApkModuleJsonEncoder encoder = new ApkModuleJsonEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        encoder.setDexEncoder(this.getSmaliCompiler());
        encoder.scanDirectory(options.inputFile);
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        if (options.resDirName != null) {
            this.logMessage("Renaming resources root dir: " + options.resDirName);
            loadedModule.setResourcesRootDir(options.resDirName);
        }
        if (options.validateResDir) {
            this.logMessage("Validating resources dir ...");
            loadedModule.validateResourcesDir();
        }
        loadedModule.getZipEntryMap().autoSortApkFiles();
        this.writeApk(loadedModule);
    }

    public void buildXml() throws IOException {
        this.logMessage("Scanning XML directory ...");
        XmlCoder.getInstance().getSetting().setLogger(this);
        ApkModuleXmlEncoder encoder = new ApkModuleXmlEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        encoder.setDexEncoder(this.getSmaliCompiler());
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        loadedModule.setPreferredFramework(options.frameworkVersion);
        for (File file : options.frameworks) {
            loadedModule.addExternalFramework(file);
        }
        encoder.scanDirectory(options.inputFile);
        loadedModule = encoder.getApkModule();
        this.writeApk(loadedModule);
    }

    public void buildRaw() throws IOException {
        this.logMessage("Scanning Raw directory ...");
        ApkModuleRawEncoder encoder = new ApkModuleRawEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        if (!options.validateResDir && options.resDirName == null) {
            encoder.setKeepOriginal(true);
            this.logMessage("Keep original binaries");
        }
        encoder.setDexEncoder(this.getSmaliCompiler());
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        loadedModule.setPreferredFramework(options.frameworkVersion);
        for (File file : options.frameworks) {
            loadedModule.addExternalFramework(file);
        }
        encoder.scanDirectory(options.inputFile);
        loadedModule = encoder.getApkModule();
        this.writeApk(loadedModule);
    }

    private void writeApk(ApkModule apkModule) throws IOException {
        BuildOptions options = (BuildOptions)this.getOptions();
        this.applyExtractNativeLibs(apkModule, options.getExtractNativeLibs());
        this.logMessage("Writing apk...");
        apkModule.writeApk(options.outputFile, null);
        apkModule.close();
        this.logMessage("Saved to: " + options.outputFile);
    }

    private SmaliCompiler getSmaliCompiler() {
        SmaliCompiler smaliCompiler = new SmaliCompiler((BuildOptions)this.getOptions());
        smaliCompiler.setApkLogger(this);
        return smaliCompiler;
    }
}

