/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.RenamedInputSource;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DexFileInputSource
extends RenamedInputSource<InputSource>
implements Comparable<DexFileInputSource> {
    public static final String DEX_DIRECTORY_NAME = ObjectsUtil.of("dex");

    public DexFileInputSource(String name, InputSource inputSource) {
        super(name, inputSource);
    }

    public int getDexNumber() {
        return InputSource.getDexNumber(this.getAlias());
    }

    @Override
    public int compareTo(DexFileInputSource source) {
        return Integer.compare(this.getDexNumber(), source.getDexNumber());
    }

    public static void sort(List<DexFileInputSource> sourceList) {
        sourceList.sort(CompareUtil.getComparableComparator());
    }

    public static void sortDexFiles(List<File> fileList) {
        fileList.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return InputSource.compareDex(file1.getName(), file2.getName());
            }
        });
    }

    public static List<File> listDexFiles(File dir) {
        ArrayList<File> results = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return results;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isFile() || !DexFileInputSource.isDexName(file.getName())) continue;
            results.add(file);
        }
        DexFileInputSource.sortDexFiles(results);
        return results;
    }

    public static boolean isDexName(String name) {
        return InputSource.getDexNumber(name) >= 0;
    }

    static String getDexName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return "classes" + i + ".dex";
    }
}

